SCR_NOW	equ	$24

	lea	bssstart,a0
clear	clr.w	(a0)+
	cmp.l	#bssend,a0
	blt.s	clear

	bsr	super_mode
	bsr	di_mouse
	bsr	low_res
	move.b	#2,$ffff820a.w
	bsr	black_palette
	BSR	start_isr
	BSR	calc_screen
	BSR	do_pre_pov
	BSR	L0030
	BSR	L0042
	JSR	tune
	MOVE.B	#6,hertz_sw
	MOVE.L	#L004D,$70.W

L0001	MOVE.W	#$FFFF,vsync_flag
L0002	tst.w	vsync_flag
		bne.s	L0002

;	clr.w	$ffff8240.w
		BSR	set_screen
		jsr	tune+8
		bsr	L0036		;something to do with mario
		bsr	print_top_logo
		bsr	print_straighten_out
		bsr	print_another_oz
		bsr	print_titles
		bsr	scroller
		bsr	L0021
		bsr	L002F
;	move.w	#$123,$ffff8240.w

	MOVE.W	key,D0
	cmp.w	#$C53,d0
	beq	reset

	cmp.b	#1,d0		;ESC
	beq	exit

	bsr	L0018
	lea	demo_keys,a0
L0003	MOVE.W	(A0)+,D1
	BMI.S	L0001
	CMP.B	D1,D0
	BEQ.S	L0004
	BRA.S	L0003
L0004	LSR.W	#7,D1
	ANDI.W	#$FFFE,D1
	LEA	L00B9,A0
	LEA	$200.W,A1
	ADDA.W	0(A0,D1.W),A0
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	BSR	L0097
	BSR	L0040
	bsr	black_palette
	bsr	low_res
	bsr	enable_mouse
	MOVE.B	#2,$FFFF820A.W
	TST.W	delay_key
	BEQ.S	L0005
	CLR.B	$FFFF820A.W
L0005	BSR	L0047
L0006	MOVE.W	#$B,-(A7)
	TRAP	#1
	ADDQ.W	#2,A7
	TST.L	D0
	BEQ.S	L0007
	move.w	#7,-(sp)
	trap	#1
	addq.w	#2,sp
	BRA.S	L0006

exit	clr.w	$ffff8240.w
	BSR	L0097
	BSR	L0040
	bsr	med_res
	bsr	enable_mouse
	MOVE.B	#2,$FFFF820A.W
	BSR	L0047
get	MOVE.W	#$B,-(A7)
	TRAP	#1
	ADDQ.W	#2,A7
	TST.L	D0
	BEQ.S	yes
	move.w	#7,-(sp)
	trap	#1
	addq.w	#2,sp
	BRA.S	get
yes
L0007	CLR.W	-(A7)
	TRAP	#1



L0008	CLR.W	vsync_flag
	RTE

do_pre_pov
	lea	intro_pic+34,a0
	move.l	screen_base,a1
	LEA	32000(A1),a2
	MOVE.W	#32000/4-1,d0
L000A	MOVE.L	(A0),(A1)+
	MOVE.L	(A0)+,(A2)+
	DBF	D0,L000A

	BSR	vsync
	BSR	set_screen
	MOVEQ	#7,D6
L000B	BSR	vsync
	BSR	vsync
	BSR	vsync
	LEA	$FFFF8240.W,A0
	LEA	intro_pic+2,A1
	MOVEQ	#$F,D7
	BSR	L0011
	DBF	D6,L000B
	MOVEQ	#$31,D0
L000C	BSR	vsync
	DBF	D0,L000C
	MOVEQ	#$B,D6
L000D	BSR	vsync
	BSR	vsync
	BSR	vsync
	LEA	$FFFF8240.W,A0
	lea	bssstart,a1
	MOVEQ	#$F,D7
	BSR	L0011
	DBF	D6,L000D

	move.l	screen_base,a0
	move.w	#64000/4-1,d0
L000E	clr.l	(a0)+
	DBF	D0,L000E
	rts

vsync	MOVE.W	#$FFFF,vsync_flag
L0010	TST.W	vsync_flag
	BNE.S	L0010
	RTS

L0011	MOVE.W	(A0),D0
	MOVE.W	(A1)+,D1
	ANDI.W	#$777,D0
	ANDI.W	#$777,D1
	MOVE.W	D0,D2
	MOVE.W	D1,D3
	ANDI.W	#$700,D2
	ANDI.W	#$700,D3
	CMP.W	D3,D2
	BEQ.S	L0013
	BLT.S	L0012
	SUBI.W	#$100,D0
	BRA.S	L0013
L0012	ADDI.W	#$100,D0
L0013	MOVE.W	D0,D2
	MOVE.W	D1,D3
	ANDI.W	#$70,D2
	ANDI.W	#$70,D3
	CMP.W	D3,D2
	BEQ.S	L0015
	BLT.S	L0014
	SUBI.W	#$10,D0
	BRA.S	L0015
L0014	ADDI.W	#$10,D0
L0015	MOVE.W	D0,D2
	MOVE.W	D1,D3
	ANDI.W	#7,D2
	ANDI.W	#7,D3
	CMP.W	D3,D2
	BEQ.S	L0017
	BLT.S	L0016
	SUBQ.W	#1,D0
	BRA.S	L0017
L0016	ADDQ.W	#1,D0
L0017	MOVE.W	D0,(A0)+
	DBF	D7,L0011
	RTS
L0018	MOVE.B	D0,D1
	ANDI.B	#$7F,D1
	CMP.B	#$B,D1
	BEQ.S	L0019
	CMP.B	#$70,D1
	BEQ.S	L0019
	RTS
L0019	BTST	#7,D0
	BNE.S	L001C
	TST.B	hertz_byte
	BNE.S	L001B
	ST	hertz_byte
	EORI.W	#$12,delay_key
	BEQ.S	L001A
	MOVE.B	#$66,hertz_sw
	RTS
L001A	MOVE.B	#6,hertz_sw
L001B	RTS
L001C	CLR.B	hertz_byte
	RTS

print_titles
	lea	titles,a0
	MOVEA.L	SCR_NOW.w,A1
	LEA	26560(A1),A1
	MOVEA.L	A1,A2
	JSR	blast_on_titles
	MOVE.B	hertz_sw,624(A2)
	RTS

print_top_logo
	LEA	L00A6,A0
	MOVEA.L	SCR_NOW.w,A1
	LEA	56(A1),A1
	JMP	L00A7

print_another_oz
	LEA	L00A8,A0
	MOVEA.L	SCR_NOW.w,A1
	LEA	31456(A1),A1
	JMP	L00A9

L0020	MOVE.L	L009A,D0
	MULU	#$1AFB,D0
	ADDI.L	#$1FCCD,D0
	MOVE.L	D0,L009A
	ANDI.L	#$7FFF,D0
	RTS

L0021	MOVE.W	L00B3,D0
	ASR.W	#2,D0
	CMP.W	#$FF60,D0
	BMI.S	L0023
	CMP.W	#$C8,D0
	BGT.S	L0024
L0022	LEA	L009C,A0
	move.l	SCR_NOW.w,a1
	muls	#160,d0
	ADD.W	L00B4,D0
	LEA	L00B7,A2
	ADDA.W	L00B6,A2
	MOVE.W	D0,(A2)
	EORI.W	#2,L00B6
	ADDA.W	D0,A1
	BRA	L009D
L0023	MOVE.W	#$FF60,D0
	BRA.S	L0022
L0024	MOVE.W	#$C8,D0
	BRA.S	L0022
L0025	MOVE.W	L00B3,D0
	CMP.W	L00B2,D0
	BMI.S	L0026
	SUBQ.W	#1,L00B5
	BEQ.S	L0028
	BRA.S	L0027
L0026	ADDQ.W	#1,L00B5
	BEQ.S	L002A
L0027	ADD.W	L00B5,D0
	MOVE.W	D0,L00B3
	ASR.W	#2,D0
	CMP.W	#$FF60,D0
	BMI.S	L002D
	CMP.W	#$C8,D0
	BGT.S	L002D
	RTS
L0028	BSR	L0020
	DIVU	#$550,D0
	SWAP	D0
	ADDI.W	#$190,D0
	MOVE.W	L00B1,D1
	SUB.W	D0,D1
	CMP.W	#$FCE0,D1
	BPL.S	L0029
	MOVE.W	#$FCE0,D1
L0029	MOVE.W	D1,L00B0
	BRA.S	L002C
L002A	BSR	L0020
	DIVU	#$550,D0
	SWAP	D0
	ADDI.W	#$190,D0
	MOVE.W	L00B0,D1
	ADD.W	D0,D1
	CMP.W	#$3C0,D1
	BLT.S	L002B
	MOVE.W	#$3C0,D1
L002B	MOVE.W	D1,L00B1
L002C	MOVE.W	L00B1,D0
	SUB.W	L00B0,D0
	ASR.W	#1,D0
	ADD.W	L00B0,D0
	MOVE.W	D0,L00B2
	RTS
L002D	ADDQ.W	#8,L00B4
	CMPI.W	#$50,L00B4
	BLT.S	L002E
	CLR.W	L00B4
L002E	RTS
L002F	BSR	L0025
	RTS
L0030	LEA	L00A2,A0
	LEA	L0053,A1
	MOVEQ	#$21,D0
L0031	MOVE.W	(A0)+,(A1)
	LEA	16(A1),A1
	DBF	D0,L0031
	LEA	L00A3,A0
	LEA	L0078,A1
	MOVEQ	#$1D,D0
L0032	MOVE.W	(A0)+,(A1)
	LEA	16(A1),A1
	DBF	D0,L0032
	RTS

set_screen	move.l	screen_base,a0
		add.l	scr_eor,a0
		move.l	a0,SCR_NOW.w
		move.l	a0,d0
		lea	$FFFF8201.W,a0
		lsr.l	#8,d0
		movep.w	d0,0(a0)
		eor.l	#57600,scr_eor
		rts

calc_screen	MOVE.L	#screens,D0
		CLR.B	D0
		MOVE.L	D0,screen_base
		MOVE.L	D0,SCR_NOW.w
		CLR.L	scr_eor
		rts

print_straighten_out
	lea	straighten_out_gfx,a0
	move.l	SCR_NOW.w,a1
	LEA	11872(A1),A1
	JMP	L00A5

L0036	LEA	L00B7,A0
	ADDA.W	L00B6,A0
	MOVE.W	(A0),D0
	MOVEA.L	SCR_NOW.w,A0
	ADDA.W	D0,A0
	MOVEQ	#0,D0
	MOVE.L	D0,D1
	MOVE.L	D0,D2
	MOVE.L	D0,D3
	MOVE.L	D0,D4
	MOVE.L	D0,D5
	MOVE.L	D0,D6
	MOVE.L	D0,D7
	MOVEA.L	D7,A1
	MOVEA.L	D7,A2
	MOVEM.L	A1-A2/D0-D7,0(A0)
	MOVEM.L	A1-A2/D0-D7,40(A0)
	MOVEM.L	A1-A2/D0-D7,160(A0)
	MOVEM.L	A1-A2/D0-D7,200(A0)
	MOVEM.L	A1-A2/D0-D7,320(A0)
	MOVEM.L	A1-A2/D0-D7,360(A0)
	MOVEM.L	A1-A2/D0-D7,480(A0)
	MOVEM.L	A1-A2/D0-D7,520(A0)
	MOVEM.L	A1-A2/D0-D7,640(A0)
	MOVEM.L	A1-A2/D0-D7,680(A0)
	MOVEM.L	A1-A2/D0-D7,800(A0)
	MOVEM.L	A1-A2/D0-D7,840(A0)
	MOVEM.L	A1-A2/D0-D7,960(A0)
	MOVEM.L	A1-A2/D0-D7,1000(A0)
	MOVEM.L	A1-A2/D0-D7,1120(A0)
	MOVEM.L	A1-A2/D0-D7,1160(A0)
	MOVEM.L	A1-A2/D0-D7,1280(A0)
	MOVEM.L	A1-A2/D0-D7,1320(A0)
	MOVEM.L	A1-A2/D0-D7,1440(A0)
	MOVEM.L	A1-A2/D0-D7,1480(A0)
	MOVEM.L	A1-A2/D0-D7,1600(A0)
	MOVEM.L	A1-A2/D0-D7,1640(A0)
	MOVEM.L	A1-A2/D0-D7,1760(A0)
	MOVEM.L	A1-A2/D0-D7,1800(A0)
	MOVEM.L	A1-A2/D0-D7,1920(A0)
	MOVEM.L	A1-A2/D0-D7,1960(A0)
	MOVEM.L	A1-A2/D0-D7,2080(A0)
	MOVEM.L	A1-A2/D0-D7,2120(A0)
	MOVEM.L	A1-A2/D0-D7,2240(A0)
	MOVEM.L	A1-A2/D0-D7,2280(A0)
	MOVEM.L	A1-A2/D0-D7,2400(A0)
	MOVEM.L	A1-A2/D0-D7,2440(A0)
	MOVEM.L	A1-A2/D0-D7,2560(A0)
	MOVEM.L	A1-A2/D0-D7,2600(A0)
	MOVEM.L	A1-A2/D0-D7,2720(A0)
	MOVEM.L	A1-A2/D0-D7,2760(A0)
	MOVEM.L	A1-A2/D0-D7,2880(A0)
	MOVEM.L	A1-A2/D0-D7,2920(A0)
	MOVEM.L	A1-A2/D0-D7,3040(A0)
	MOVEM.L	A1-A2/D0-D7,3080(A0)
	MOVEM.L	A1-A2/D0-D7,3200(A0)
	MOVEM.L	A1-A2/D0-D7,3240(A0)
	MOVEM.L	A1-A2/D0-D7,3360(A0)
	MOVEM.L	A1-A2/D0-D7,3400(A0)
	MOVEM.L	A1-A2/D0-D7,3520(A0)
	MOVEM.L	A1-A2/D0-D7,3560(A0)
	MOVEM.L	A1-A2/D0-D7,3680(A0)
	MOVEM.L	A1-A2/D0-D7,3720(A0)
	MOVEM.L	A1-A2/D0-D7,3840(A0)
	MOVEM.L	A1-A2/D0-D7,3880(A0)
	MOVEM.L	A1-A2/D0-D7,4000(A0)
	MOVEM.L	A1-A2/D0-D7,4040(A0)
	MOVEM.L	A1-A2/D0-D7,4160(A0)
	MOVEM.L	A1-A2/D0-D7,4200(A0)
	MOVEM.L	A1-A2/D0-D7,4320(A0)
	MOVEM.L	A1-A2/D0-D7,4360(A0)
	MOVEM.L	A1-A2/D0-D7,4480(A0)
	MOVEM.L	A1-A2/D0-D7,4520(A0)
	MOVEM.L	A1-A2/D0-D7,4640(A0)
	MOVEM.L	A1-A2/D0-D7,4680(A0)
	MOVEM.L	A1-A2/D0-D7,4800(A0)
	MOVEM.L	A1-A2/D0-D7,4840(A0)
	MOVEM.L	A1-A2/D0-D7,4960(A0)
	MOVEM.L	A1-A2/D0-D7,5000(A0)
	MOVEM.L	A1-A2/D0-D7,5120(A0)
	MOVEM.L	A1-A2/D0-D7,5160(A0)
	MOVEM.L	A1-A2/D0-D7,5280(A0)
	MOVEM.L	A1-A2/D0-D7,5320(A0)
	MOVEM.L	A1-A2/D0-D7,5440(A0)
	MOVEM.L	A1-A2/D0-D7,5480(A0)
	MOVEM.L	A1-A2/D0-D7,5600(A0)
	MOVEM.L	A1-A2/D0-D7,5640(A0)
	MOVEM.L	A1-A2/D0-D7,5760(A0)
	MOVEM.L	A1-A2/D0-D7,5800(A0)
	MOVEM.L	A1-A2/D0-D7,5920(A0)
	MOVEM.L	A1-A2/D0-D7,5960(A0)
	MOVEM.L	A1-A2/D0-D7,6080(A0)
	MOVEM.L	A1-A2/D0-D7,6120(A0)
	MOVEM.L	A1-A2/D0-D7,6240(A0)
	MOVEM.L	A1-A2/D0-D7,6280(A0)
	MOVEM.L	A1-A2/D0-D7,6400(A0)
	MOVEM.L	A1-A2/D0-D7,6440(A0)
	MOVEM.L	A1-A2/D0-D7,6560(A0)
	MOVEM.L	A1-A2/D0-D7,6600(A0)
	MOVEM.L	A1-A2/D0-D7,6720(A0)
	MOVEM.L	A1-A2/D0-D7,6760(A0)
	MOVEM.L	A1-A2/D0-D7,6880(A0)
	MOVEM.L	A1-A2/D0-D7,6920(A0)
	MOVEM.L	A1-A2/D0-D7,7040(A0)
	MOVEM.L	A1-A2/D0-D7,7080(A0)
	MOVEM.L	A1-A2/D0-D7,7200(A0)
	MOVEM.L	A1-A2/D0-D7,7240(A0)
	MOVEM.L	A1-A2/D0-D7,7360(A0)
	MOVEM.L	A1-A2/D0-D7,7400(A0)
	MOVEM.L	A1-A2/D0-D7,7520(A0)
	MOVEM.L	A1-A2/D0-D7,7560(A0)
	MOVEM.L	A1-A2/D0-D7,7680(A0)
	MOVEM.L	A1-A2/D0-D7,7720(A0)
	MOVEM.L	A1-A2/D0-D7,7840(A0)
	MOVEM.L	A1-A2/D0-D7,7880(A0)
	MOVEM.L	A1-A2/D0-D7,8000(A0)
	MOVEM.L	A1-A2/D0-D7,8040(A0)
	MOVEM.L	A1-A2/D0-D7,8160(A0)
	MOVEM.L	A1-A2/D0-D7,8200(A0)
	MOVEM.L	A1-A2/D0-D7,8320(A0)
	MOVEM.L	A1-A2/D0-D7,8360(A0)
	MOVEM.L	A1-A2/D0-D7,8480(A0)
	MOVEM.L	A1-A2/D0-D7,8520(A0)
	MOVEM.L	A1-A2/D0-D7,8640(A0)
	MOVEM.L	A1-A2/D0-D7,8680(A0)
	MOVEM.L	A1-A2/D0-D7,8800(A0)
	MOVEM.L	A1-A2/D0-D7,8840(A0)
	MOVEM.L	A1-A2/D0-D7,8960(A0)
	MOVEM.L	A1-A2/D0-D7,9000(A0)
	MOVEM.L	A1-A2/D0-D7,9120(A0)
	MOVEM.L	A1-A2/D0-D7,9160(A0)
	MOVEM.L	A1-A2/D0-D7,9280(A0)
	MOVEM.L	A1-A2/D0-D7,9320(A0)
	MOVEM.L	A1-A2/D0-D7,9440(A0)
	MOVEM.L	A1-A2/D0-D7,9480(A0)
	MOVEM.L	A1-A2/D0-D7,9600(A0)
	MOVEM.L	A1-A2/D0-D7,9640(A0)
	MOVEM.L	A1-A2/D0-D7,9760(A0)
	MOVEM.L	A1-A2/D0-D7,9800(A0)
	MOVEM.L	A1-A2/D0-D7,9920(A0)
	MOVEM.L	A1-A2/D0-D7,9960(A0)
	MOVEM.L	A1-A2/D0-D7,10080(A0)
	MOVEM.L	A1-A2/D0-D7,10120(A0)
	MOVEM.L	A1-A2/D0-D7,10240(A0)
	MOVEM.L	A1-A2/D0-D7,10280(A0)
	MOVEM.L	A1-A2/D0-D7,10400(A0)
	MOVEM.L	A1-A2/D0-D7,10440(A0)
	MOVEM.L	A1-A2/D0-D7,10560(A0)
	MOVEM.L	A1-A2/D0-D7,10600(A0)
	MOVEM.L	A1-A2/D0-D7,10720(A0)
	MOVEM.L	A1-A2/D0-D7,10760(A0)
	MOVEM.L	A1-A2/D0-D7,10880(A0)
	MOVEM.L	A1-A2/D0-D7,10920(A0)
	MOVEM.L	A1-A2/D0-D7,11040(A0)
	MOVEM.L	A1-A2/D0-D7,11080(A0)
	MOVEM.L	A1-A2/D0-D7,11200(A0)
	MOVEM.L	A1-A2/D0-D7,11240(A0)
	MOVEM.L	A1-A2/D0-D7,11360(A0)
	MOVEM.L	A1-A2/D0-D7,11400(A0)
	MOVEM.L	A1-A2/D0-D7,11520(A0)
	MOVEM.L	A1-A2/D0-D7,11560(A0)
	MOVEM.L	A1-A2/D0-D7,11680(A0)
	MOVEM.L	A1-A2/D0-D7,11720(A0)
	MOVEM.L	A1-A2/D0-D7,11840(A0)
	MOVEM.L	A1-A2/D0-D7,11880(A0)
	MOVEM.L	A1-A2/D0-D7,12000(A0)
	MOVEM.L	A1-A2/D0-D7,12040(A0)
	MOVEM.L	A1-A2/D0-D7,12160(A0)
	MOVEM.L	A1-A2/D0-D7,12200(A0)
	MOVEM.L	A1-A2/D0-D7,12320(A0)
	MOVEM.L	A1-A2/D0-D7,12360(A0)
	MOVEM.L	A1-A2/D0-D7,12480(A0)
	MOVEM.L	A1-A2/D0-D7,12520(A0)
	MOVEM.L	A1-A2/D0-D7,12640(A0)
	MOVEM.L	A1-A2/D0-D7,12680(A0)
	MOVEM.L	A1-A2/D0-D7,12800(A0)
	MOVEM.L	A1-A2/D0-D7,12840(A0)
	MOVEM.L	A1-A2/D0-D7,12960(A0)
	MOVEM.L	A1-A2/D0-D7,13000(A0)
	MOVEM.L	A1-A2/D0-D7,13120(A0)
	MOVEM.L	A1-A2/D0-D7,13160(A0)
	MOVEM.L	A1-A2/D0-D7,13280(A0)
	MOVEM.L	A1-A2/D0-D7,13320(A0)
	MOVEM.L	A1-A2/D0-D7,13440(A0)
	MOVEM.L	A1-A2/D0-D7,13480(A0)
	MOVEM.L	A1-A2/D0-D7,13600(A0)
	MOVEM.L	A1-A2/D0-D7,13640(A0)
	MOVEM.L	A1-A2/D0-D7,13760(A0)
	MOVEM.L	A1-A2/D0-D7,13800(A0)
	MOVEM.L	A1-A2/D0-D7,13920(A0)
	MOVEM.L	A1-A2/D0-D7,13960(A0)
	MOVEM.L	A1-A2/D0-D7,14080(A0)
	MOVEM.L	A1-A2/D0-D7,14120(A0)
	MOVEM.L	A1-A2/D0-D7,14240(A0)
	MOVEM.L	A1-A2/D0-D7,14280(A0)
	MOVEM.L	A1-A2/D0-D7,14400(A0)
	MOVEM.L	A1-A2/D0-D7,14440(A0)
	MOVEM.L	A1-A2/D0-D7,14560(A0)
	MOVEM.L	A1-A2/D0-D7,14600(A0)
	MOVEM.L	A1-A2/D0-D7,14720(A0)
	MOVEM.L	A1-A2/D0-D7,14760(A0)
	MOVEM.L	A1-A2/D0-D7,14880(A0)
	MOVEM.L	A1-A2/D0-D7,14920(A0)
	MOVEM.L	A1-A2/D0-D7,15040(A0)
	MOVEM.L	A1-A2/D0-D7,15080(A0)
	MOVEM.L	A1-A2/D0-D7,15200(A0)
	MOVEM.L	A1-A2/D0-D7,15240(A0)
	MOVEM.L	A1-A2/D0-D7,15360(A0)
	MOVEM.L	A1-A2/D0-D7,15400(A0)
	MOVEM.L	A1-A2/D0-D7,15520(A0)
	MOVEM.L	A1-A2/D0-D7,15560(A0)
	MOVEM.L	A1-A2/D0-D7,15680(A0)
	MOVEM.L	A1-A2/D0-D7,15720(A0)
	MOVEM.L	A1-A2/D0-D7,15840(A0)
	MOVEM.L	A1-A2/D0-D7,15880(A0)
	MOVEM.L	A1-A2/D0-D7,16000(A0)
	MOVEM.L	A1-A2/D0-D7,16040(A0)
	MOVEM.L	A1-A2/D0-D7,16160(A0)
	MOVEM.L	A1-A2/D0-D7,16200(A0)
	MOVEM.L	A1-A2/D0-D7,16320(A0)
	MOVEM.L	A1-A2/D0-D7,16360(A0)
	MOVEM.L	A1-A2/D0-D7,16480(A0)
	MOVEM.L	A1-A2/D0-D7,16520(A0)
	MOVEM.L	A1-A2/D0-D7,16640(A0)
	MOVEM.L	A1-A2/D0-D7,16680(A0)
	MOVEM.L	A1-A2/D0-D7,16800(A0)
	MOVEM.L	A1-A2/D0-D7,16840(A0)
	MOVEM.L	A1-A2/D0-D7,16960(A0)
	MOVEM.L	A1-A2/D0-D7,17000(A0)
	MOVEM.L	A1-A2/D0-D7,17120(A0)
	MOVEM.L	A1-A2/D0-D7,17160(A0)
	MOVEM.L	A1-A2/D0-D7,17280(A0)
	MOVEM.L	A1-A2/D0-D7,17320(A0)
	MOVEM.L	A1-A2/D0-D7,17440(A0)
	MOVEM.L	A1-A2/D0-D7,17480(A0)
	MOVEM.L	A1-A2/D0-D7,17600(A0)
	MOVEM.L	A1-A2/D0-D7,17640(A0)
	MOVEM.L	A1-A2/D0-D7,17760(A0)
	MOVEM.L	A1-A2/D0-D7,17800(A0)
	MOVEM.L	A1-A2/D0-D7,17920(A0)
	MOVEM.L	A1-A2/D0-D7,17960(A0)
	MOVEM.L	A1-A2/D0-D7,18080(A0)
	MOVEM.L	A1-A2/D0-D7,18120(A0)
	MOVEM.L	A1-A2/D0-D7,18240(A0)
	MOVEM.L	A1-A2/D0-D7,18280(A0)
	MOVEM.L	A1-A2/D0-D7,18400(A0)
	MOVEM.L	A1-A2/D0-D7,18440(A0)
	MOVEM.L	A1-A2/D0-D7,18560(A0)
	MOVEM.L	A1-A2/D0-D7,18600(A0)
	MOVEM.L	A1-A2/D0-D7,18720(A0)
	MOVEM.L	A1-A2/D0-D7,18760(A0)
	MOVEM.L	A1-A2/D0-D7,18880(A0)
	MOVEM.L	A1-A2/D0-D7,18920(A0)
	MOVEM.L	A1-A2/D0-D7,19040(A0)
	MOVEM.L	A1-A2/D0-D7,19080(A0)
	MOVEM.L	A1-A2/D0-D7,19200(A0)
	MOVEM.L	A1-A2/D0-D7,19240(A0)
	MOVEM.L	A1-A2/D0-D7,19360(A0)
	MOVEM.L	A1-A2/D0-D7,19400(A0)
	MOVEM.L	A1-A2/D0-D7,19520(A0)
	MOVEM.L	A1-A2/D0-D7,19560(A0)
	MOVEM.L	A1-A2/D0-D7,19680(A0)
	MOVEM.L	A1-A2/D0-D7,19720(A0)
	MOVEM.L	A1-A2/D0-D7,19840(A0)
	MOVEM.L	A1-A2/D0-D7,19880(A0)
	MOVEM.L	A1-A2/D0-D7,20000(A0)
	MOVEM.L	A1-A2/D0-D7,20040(A0)
	MOVEM.L	A1-A2/D0-D7,20160(A0)
	MOVEM.L	A1-A2/D0-D7,20200(A0)
	MOVEM.L	A1-A2/D0-D7,20320(A0)
	MOVEM.L	A1-A2/D0-D7,20360(A0)
	MOVEM.L	A1-A2/D0-D7,20480(A0)
	MOVEM.L	A1-A2/D0-D7,20520(A0)
	MOVEM.L	A1-A2/D0-D7,20640(A0)
	MOVEM.L	A1-A2/D0-D7,20680(A0)
	MOVEM.L	A1-A2/D0-D7,20800(A0)
	MOVEM.L	A1-A2/D0-D7,20840(A0)
	MOVEM.L	A1-A2/D0-D7,20960(A0)
	MOVEM.L	A1-A2/D0-D7,21000(A0)
	MOVEM.L	A1-A2/D0-D7,21120(A0)
	MOVEM.L	A1-A2/D0-D7,21160(A0)
	MOVEM.L	A1-A2/D0-D7,21280(A0)
	MOVEM.L	A1-A2/D0-D7,21320(A0)
	MOVEM.L	A1-A2/D0-D7,21440(A0)
	MOVEM.L	A1-A2/D0-D7,21480(A0)
	MOVEM.L	A1-A2/D0-D7,21600(A0)
	MOVEM.L	A1-A2/D0-D7,21640(A0)
	MOVEM.L	A1-A2/D0-D7,21760(A0)
	MOVEM.L	A1-A2/D0-D7,21800(A0)
	MOVEM.L	A1-A2/D0-D7,21920(A0)
	MOVEM.L	A1-A2/D0-D7,21960(A0)
	MOVEM.L	A1-A2/D0-D7,22080(A0)
	MOVEM.L	A1-A2/D0-D7,22120(A0)
	MOVEM.L	A1-A2/D0-D7,22240(A0)
	MOVEM.L	A1-A2/D0-D7,22280(A0)
	MOVEM.L	A1-A2/D0-D7,22400(A0)
	MOVEM.L	A1-A2/D0-D7,22440(A0)
	MOVEM.L	A1-A2/D0-D7,22560(A0)
	MOVEM.L	A1-A2/D0-D7,22600(A0)
	MOVEM.L	A1-A2/D0-D7,22720(A0)
	MOVEM.L	A1-A2/D0-D7,22760(A0)
	MOVEM.L	A1-A2/D0-D7,22880(A0)
	MOVEM.L	A1-A2/D0-D7,22920(A0)
	MOVEM.L	A1-A2/D0-D7,23040(A0)
	MOVEM.L	A1-A2/D0-D7,23080(A0)
	MOVEM.L	A1-A2/D0-D7,23200(A0)
	MOVEM.L	A1-A2/D0-D7,23240(A0)
	MOVEM.L	A1-A2/D0-D7,23360(A0)
	MOVEM.L	A1-A2/D0-D7,23400(A0)
	MOVEM.L	A1-A2/D0-D7,23520(A0)
	MOVEM.L	A1-A2/D0-D7,23560(A0)
	MOVEM.L	A1-A2/D0-D7,23680(A0)
	MOVEM.L	A1-A2/D0-D7,23720(A0)
	MOVEM.L	A1-A2/D0-D7,23840(A0)
	MOVEM.L	A1-A2/D0-D7,23880(A0)
	MOVEM.L	A1-A2/D0-D7,24000(A0)
	MOVEM.L	A1-A2/D0-D7,24040(A0)
	MOVEM.L	A1-A2/D0-D7,24160(A0)
	MOVEM.L	A1-A2/D0-D7,24200(A0)
	MOVEM.L	A1-A2/D0-D7,24320(A0)
	MOVEM.L	A1-A2/D0-D7,24360(A0)
	MOVEM.L	A1-A2/D0-D7,24480(A0)
	MOVEM.L	A1-A2/D0-D7,24520(A0)
	MOVEM.L	A1-A2/D0-D7,24640(A0)
	MOVEM.L	A1-A2/D0-D7,24680(A0)
	MOVEM.L	A1-A2/D0-D7,24800(A0)
	MOVEM.L	A1-A2/D0-D7,24840(A0)
	MOVEM.L	A1-A2/D0-D7,24960(A0)
	MOVEM.L	A1-A2/D0-D7,25000(A0)
	MOVEM.L	A1-A2/D0-D7,25120(A0)
	MOVEM.L	A1-A2/D0-D7,25160(A0)
	MOVEM.L	A1-A2/D0-D7,25280(A0)
	MOVEM.L	A1-A2/D0-D7,25320(A0)
	MOVEM.L	A1-A2/D0-D7,25440(A0)
	MOVEM.L	A1-A2/D0-D7,25480(A0)
	RTS


scroller
	move.l	SCR_NOW,a1
	lea	160*116(a1),a1
	lea	font_offsets,a2
	lea	font,a3
	move.l	scroll_pointer,a4
	move.l	a4,a5

	moveq	#0,d4
	moveq	#40,d5
	move.w	char_off,d6
next_char
	move.b	(a5),d7		;get a letter
	ext.w	d7

	moveq	#0,d0
	move.l	a3,a0
	move.b	d7,d0
	mulu	#4*34,d0	;char depth * width
	add.w	d0,a0
	move.w	d6,d0
	mulu	#34,d0		;char depth
	add.w	d0,a0

.column
OFF	set	0
	REPT	34
	move.b	(a0)+,OFF(a1)
OFF	set	OFF+160
	ENDR

	subq.w	#1,d5
	beq.s	.finish

	add.w	#1,a1		;lower byte of word
	tst.w	d4
	beq.s	.skip		;if D4=0 then do next word
	add.w	#6,a1		;else goto next word on screen
.skip	not.w	d4
	addq.w	#1,d6		;character offset
	and.w	#3,d6
	bne	.column

	addq.w	#1,a5		;scroll pointer
	tst.b	(a5)		;is end of text?
	bpl	next_char	;NO!
	lea	scroll_text,a5	;do reset scrolline
	bra	next_char

.finish
	addq.w	#1,char_off
	and.w	#3,char_off
	bne.s	.end
	addq.w	#1,a4
	tst.b	(a4)
	bpl.s	.end
	lea	scroll_text,a4
.end	move.l	a4,scroll_pointer
	rts


reset	move.w	#$2700,sr
	move.l	4.w,a0
	jmp	(a0)

start_isr	MOVE	SR,-(A7)
	ORI.W	#$700,SR
	LEA	vect_save,A0
	MOVE.L	$70.W,(A0)+
	MOVE.L	$118.W,(A0)+
	MOVE.L	$120.W,(A0)+
	LEA	store_system,A0
	MOVE.B	$FFFFFA07.W,(A0)+
	MOVE.B	$FFFFFA09.W,(A0)+
	MOVE.B	$FFFFFA13.W,(A0)+
	MOVE.B	$FFFFFA15.W,(A0)+
	MOVE.B	$FFFFFA17.W,(A0)+
	MOVE.B	$FFFFFA1B.W,(A0)+
	MOVE.B	$FFFFFA21.W,(A0)+
	MOVE.L	#L0008,$70.W
	MOVE.L	#L0048,$118.W
	MOVE.B	#1,$FFFFFA07.W
	MOVE.B	#1,$FFFFFA13.W
	MOVE.B	#$40,$FFFFFA09.W
	MOVE.B	#$40,$FFFFFA15.W
	BCLR	#3,$FFFFFA17.W
	CLR.B	$FFFFFA1B.W
	MOVE	(A7)+,SR
	RTS

L0040	MOVE	SR,-(A7)
	ORI.W	#$700,SR
	LEA	vect_save,A0
	MOVE.L	(A0)+,$70.W
	MOVE.L	(A0)+,$118.W
	MOVE.L	(A0)+,$120.W
	LEA	store_system,A0
	MOVE.B	(A0)+,$FFFFFA07.W
	MOVE.B	(A0)+,$FFFFFA09.W
	MOVE.B	(A0)+,$FFFFFA13.W
	MOVE.B	(A0)+,$FFFFFA15.W
	MOVE.B	(A0)+,$FFFFFA17.W
	MOVE.B	(A0)+,$FFFFFA1B.W
	MOVE.B	(A0)+,$FFFFFA21.W
	MOVE	(A7)+,SR
	RTS
	MOVE.W	#$25,-(A7)
	TRAP	#$E
	ADDQ.W	#2,A7
	RTS

med_res	move.w	#1,-(sp)
	bra.s	set_r
low_res	clr.w	-(sp)
set_r	move.l	$44e.w,-(sp)
	move.l	$44e.w,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.w	#12,sp
	rts

L0042	MOVEM.L	L009B,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	RTS

black_palette
	lea	$ffff8240.w,a0
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	rts

di_mouse	pea	dis_mouse
		move.w	#1,-(sp)
		move.w	#$19,-(sp)
		trap	#14
		addq.w	#8,sp
		rts

enable_mouse	pea	ena_mouse
		move.w	#1,-(sp)
		move.w	#$19,-(sp)
		trap	#14
		addq.w	#8,sp
		rts

super_mode
	clr.l	-(sp)
	move.w	#32,-(sp)
	trap	#1
	addq.w	#6,sp
	move.l	d0,save_stk
	rts

L0047	MOVE.L	save_stk,-(A7)
	MOVE.W	#$20,-(A7)
	TRAP	#1
	ADDQ.W	#6,A7
	RTS
L0048	MOVE.L	D0,-(A7)
	MOVE.B	$FFFFFC02.W,D0
	CMP.B	#$1D,D0
	BNE.S	L0049
	BSET	#2,key
L0049	CMP.B	#$9D,D0
	BNE.S	L004A
	BCLR	#2,key
L004A	CMP.B	#$38,D0
	BNE.S	L004B
	BSET	#3,key
L004B	CMP.B	#$B8,D0
	BNE.S	L004C
	BCLR	#3,key
L004C	MOVE.B	D0,key+1
	BCLR	#6,$FFFFFA11.W
	MOVE.L	(A7)+,D0
	RTE
L004D	CLR.W	vsync_flag
	CLR.B	$FFFFFA1B.W
	MOVE.B	#$4A,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#L004E,$120.W
	MOVE.W	#$700,$FFFF8242.W
	MOVE.L	#$3500047,$FFFF8244.W
	RTE
L004E	CLR.B	$FFFFFA1B.W
	MOVE.B	#$D,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#$1270327,$FFFF8242.W
	MOVE.L	#L004F,$120.W
	RTE
L004F	CLR.B	$FFFFFA1B.W
	MOVE.B	#6,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.W	#$527,$FFFF8242.W
	MOVE.L	#L0050,$120.W
	RTE
L0050	CLR.B	$FFFFFA1B.W
	MOVE.B	#$16,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.W	#$727,$FFFF8244.W
	MOVE.L	#L0051,$120.W
	RTE
L0051	CLR.B	$FFFFFA1B.W
	MOVE.B	#1,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#L0052,$120.W
	RTE
L0052	MOVE.W	#$777,$FFFF8242.W
L0053	EQU	*-4
	MOVE.L	#L0054,$120.W
	RTE
L0054	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0055,$120.W
	RTE
L0055	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0056,$120.W
	RTE
L0056	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0057,$120.W
	RTE
L0057	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0058,$120.W
	RTE
L0058	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0059,$120.W
	RTE
L0059	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005A,$120.W
	RTE
L005A	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005B,$120.W
	RTE
L005B	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005C,$120.W
	RTE
L005C	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005D,$120.W
	RTE
L005D	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005E,$120.W
	RTE
L005E	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L005F,$120.W
	RTE
L005F	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0060,$120.W
	RTE
L0060	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0061,$120.W
	RTE
L0061	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0062,$120.W
	RTE
L0062	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0063,$120.W
	RTE
L0063	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0064,$120.W
	RTE
L0064	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0065,$120.W
	RTE
L0065	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0066,$120.W
	RTE
L0066	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0067,$120.W
	RTE
L0067	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0068,$120.W
	RTE
L0068	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0069,$120.W
	RTE
L0069	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006A,$120.W
	RTE
L006A	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006B,$120.W
	RTE
L006B	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006C,$120.W
	RTE
L006C	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006D,$120.W
	RTE
L006D	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006E,$120.W
	RTE
L006E	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L006F,$120.W
	RTE
L006F	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0070,$120.W
	RTE
L0070	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0071,$120.W
	RTE
L0071	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0072,$120.W
	RTE
L0072	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0073,$120.W
	RTE
L0073	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0074,$120.W
	RTE
L0074	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0075,$120.W
	RTE
L0075	CLR.B	$FFFFFA1B.W
	MOVE.B	#$F,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#L0076,$120.W
	RTE
L0076	CLR.B	$FFFFFA1B.W
	MOVE.B	#1,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#L0077,$120.W
	RTE
L0077	MOVE.W	#$777,$FFFF8242.W
L0078	EQU	*-4
	MOVE.L	#L0079,$120.W
	RTE
L0079	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007A,$120.W
	RTE
L007A	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007B,$120.W
	RTE
L007B	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007C,$120.W
	RTE
L007C	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007D,$120.W
	RTE
L007D	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007E,$120.W
	RTE
L007E	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L007F,$120.W
	RTE
L007F	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0080,$120.W
	RTE
L0080	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0081,$120.W
	RTE
L0081	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0082,$120.W
	RTE
L0082	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0083,$120.W
	RTE
L0083	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0084,$120.W
	RTE
L0084	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0085,$120.W
	RTE
L0085	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0086,$120.W
	RTE
L0086	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0087,$120.W
	RTE
L0087	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0088,$120.W
	RTE
L0088	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0089,$120.W
	RTE
L0089	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008A,$120.W
	RTE
L008A	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008B,$120.W
	RTE
L008B	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008C,$120.W
	RTE
L008C	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008D,$120.W
	RTE
L008D	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008E,$120.W
	RTE
L008E	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L008F,$120.W
	RTE
L008F	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0090,$120.W
	RTE
L0090	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0091,$120.W
	RTE
L0091	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0092,$120.W
	RTE
L0092	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0093,$120.W
	RTE
L0093	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0094,$120.W
	RTE
L0094	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0095,$120.W
	RTE
L0095	MOVE.W	#$777,$FFFF8242.W
	MOVE.L	#L0096,$120.W
	RTE
L0096	CLR.B	$FFFFFA1B.W
	MOVE.L	#$5270727,$FFFF8242.W
	RTE
L0097	LEA	$FFFF8800.W,A0
	MOVE.L	#$8080000,(A0)
	MOVE.L	#$9090000,(A0)
	MOVE.L	#$A0A0000,(A0)
	RTS
DATA

dis_mouse	dc.b	$12,$1a

ena_mouse	dc.b	$14,$08

L009A	DC.B	$00,$00,$00,')'
L009B	DC.B	$00,$00,$01,$27,$03,$27,$05,$27
	DC.B	$07,$27,$03,'P',$00,$00,$00,'p'
	DC.B	$00,'G',$06,'B',$05,'w',$07,'`'
	DC.B	$04,$10,$07,'S',$07,$00,$07,'w'
L009C	DC.B	$FC,$00,$FC,$00,$00,$00,$03,$FF
	DC.B	$03,$FF,$00,$00,'?',$FF,'?',$FF
	DC.B	$00,$00,$C0,$00,$C0,$00,$00,$00
	DC.B	$80,$00,$80,$00,$00,$00,$7F,$FF
	DC.B	$7F,$FF,$03,$FF,$03,$FF,$03,$FF
	DC.B	$00,$00,$FC,$00,$FC,$00,$C0,$00
	DC.B	$FF,$F8,$FF,$F8,$00,$00,$00,$07
	DC.B	$00,$07,$00,$00,$00,$00,$FF,$FF
	DC.B	$FF,$FF,$7F,$FF,$00,$7F,$00,$7F
	DC.B	$00,$00,$FF,$80,$FF,$80,$FC,$00
	DC.B	$FF,$C0,$FF,$C0,$00,$00,$00,'?'
	DC.B	$00,'?',$00,$07,$00,$00,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$00,$1F,$00,$1F
	DC.B	$00,$00,$FF,$E0,$FF,$E0,$FF,$80
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF
	DC.B	$01,$FF,$00,'?',$00,$00,$FF,$FF
	DC.B	$FF,$FF,$00,$07,$00,$07,$00,$07
	DC.B	$00,$00,$FF,$F8,$FF,$F8,$FF,$E0
	DC.B	$F8,$00,$F8,$00,$00,$00,$07,$FF
	DC.B	$07,$FF,$01,$E0,$FF,$F8,$FF,$FF
	DC.B	$FF,$FF,$FF,$F8,$00,$01,$00,$01
	DC.B	$00,$00,$FF,$FE,$FF,$FE,'?',$F8
	DC.B	$E0,$00,$E0,$00,$00,$1F,$1F,$FF
	DC.B	$1F,$FF,$07,$9F,$BF,$EF,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$C0,$00,$FF,$FF
	DC.B	$FF,$FF,$CF,$FE,$7F,$FF,$7F,$FF
	DC.B	$00,$00,$80,$00,$80,$00,$00,$00
	DC.B	$80,$00,$80,$00,$00,$7F,$7F,$FF
	DC.B	$7F,$FF,$1F,$7F,$1F,$C7,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$F0,$00,$FF,$FF
	DC.B	$FF,$FF,$F7,$FF,$1F,$FF,$1F,$FF
	DC.B	$00,$00,$E0,$00,$E0,$00,$80,$00
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01
	DC.B	$00,$01,$00,$00,$00,$FE,$FF,$FF
	DC.B	$FF,$FF,'~',$FF,$0F,$83,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$F8,$00,$FF,$FF
	DC.B	$FF,$FF,$FB,$FF,$0F,$FF,$0F,$FF
	DC.B	$00,$00,$F0,$00,$F0,$00,$E0,$00
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03
	DC.B	$00,$03,$00,$01,$01,$FC,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,$07,$01,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$FC,$00,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,$07,$FF,$07,$FF
	DC.B	$00,$00,$F8,$00,$F8,$00,$F0,$00
	DC.B	$FF,$F8,$FF,$F8,$00,$00,$00,$07
	DC.B	$00,$07,$00,$03,$01,$F8,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,'B',$10,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$FC,$00,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,$03,$FF,$03,$FF
	DC.B	$00,$00,$FC,$00,$FC,$00,$F8,$00
	DC.B	$FF,$F0,$FF,$F0,$00,$00,$00,$0F
	DC.B	$00,$0F,$00,$07,$03,$F0,$FF,$FF
	DC.B	$FF,$FF,$FB,$FF,$E0,'8',$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,'~',$00,$FF,$FF
	DC.B	$FF,$FF,$FE,$FF,$01,$FF,$01,$FF
	DC.B	$00,$00,$FE,$00,$FE,$00,$FC,$00
	DC.B	$FF,$E0,$FF,$E0,$00,$00,$00,$1F
	DC.B	$00,$1F,$00,$0F,$03,$E1,$FF,$FF
	DC.B	$FF,$FF,$FB,$FF,$F0,'|',$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,'>',$00,$FF,$FF
	DC.B	$FF,$FF,$FE,$FF,$00,$FF,$00,$FF
	DC.B	$00,$00,$FF,$00,$FF,$00,$FE,$00
	DC.B	$FF,$C0,$FF,$C0,$00,$00,$00,'?'
	DC.B	$00,'?',$00,$1F,$03,$C3,$FF,$FF
	DC.B	$FF,$FF,$FB,$FF,$F8,$FE,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$1E,$00,$FF,$FF
	DC.B	$FF,$FF,$FE,$FF,$00,$7F,$00,$7F
	DC.B	$00,$00,$FF,$80,$FF,$80,$FF,$00
	DC.B	$FE,'?',$FE,'?',$00,$00,$01,$C0
	DC.B	$01,$C0,$00,$00,$FF,$80,$FF,$80
	DC.B	$00,$00,$00,$7F,$00,$7F,$00,'?'
	DC.B	$01,$87,$FF,$FF,$FF,$FF,$FD,$FF
	DC.B	$FD,$FF,$FF,$FF,$FF,$FF,$FF,$FF
	DC.B	$0C,$00,$FF,$FF,$FF,$FF,$FD,$FF
	DC.B	$00,'?',$00,'?',$00,$00,$FF,$C0
	DC.B	$FF,$C0,$FF,$80,$F8,$0F,$F8,$0F
	DC.B	$00,$00,$07,$F0,$06,'0',$01,$C0
	DC.B	$FF,$00,$FF,$00,$00,$00,$00,$FF
	DC.B	$00,$FF,$00,$7F,$01,$0F,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,$C0,$1F,$FF,$FF
	DC.B	$FF,$FF,$C0,$1F,$84,$00,$FF,$FF
	DC.B	$FF,$FF,$FD,$FF,$00,'?',$00,'?'
	DC.B	$00,$00,$FF,$C0,$FF,$C0,$FF,$80
	DC.B	$F0,$03,$F0,$03,$00,$00,$0F,$FC
	DC.B	$08,$0C,$07,$F0,$FF,$00,$FF,$00
	DC.B	$00,$00,$00,$FF,$00,$FF,$00,$7F
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FE,$E0
	DC.B	$00,$00,$FF,$FF,$FF,$FF,'?',$E0
	DC.B	'@',$00,$FF,$FF,$FF,$FF,'{',$FF
	DC.B	$00,$1F,$00,$1F,$00,$00,$FF,$E0
	DC.B	$FF,$E0,$FF,$C0,$E0,$01,$E0,$01
	DC.B	$00,$00,$1F,$FE,$10,$02,$0F,$FC
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF
	DC.B	$01,$FF,$00,$FF,$00,$00,$FF,$FF
	DC.B	$FF,$FF,$FE,$1F,$00,$00,$FF,$FF
	DC.B	$FF,$FF,$FF,$FF,$00,$00,$FF,$FF
	DC.B	$FF,$FF,$87,$FF,$00,$1F,$00,$1F
	DC.B	$00,$00,$FF,$E0,$FF,$E0,$FF,$C0
	DC.B	$E0,$00,$E0,$00,$00,$00,$1F,$FF
	DC.B	$10,$01,$0F,$FE,$FE,$00,$FE,$00
	DC.B	$00,$00,$01,$FF,$01,$FF,$00,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$F1,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$F8,$7F
	DC.B	$00,$0F,$00,$0F,$00,$00,$FF,$F0
	DC.B	$FF,$F0,$FF,$E0,$E0,$00,$E0,$00
	DC.B	$00,$00,$1F,$FF,$10,$00,$0F,$FF
	DC.B	$7F,$FF,$7F,$FF,$00,$00,$80,$00
	DC.B	$80,$00,$00,$00,$FE,$00,$FE,$00
	DC.B	$00,$00,$01,$FF,$01,$FF,$00,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$8F,$03
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$8F
	DC.B	$00,$0F,$00,$0F,$00,$00,$FF,$F0
	DC.B	$FF,$F0,$FF,$E0,$C0,$00,$C0,$00
	DC.B	$00,$00,'?',$FF,' ',$00,$1F,$FF
	DC.B	'?',$FF,'?',$FF,$00,$00,$C0,$00
	DC.B	'@',$00,$80,$00,$FC,$00,$FC,$00
	DC.B	$00,$00,$03,$FF,$03,$FF,$01,$FE
	DC.B	$00,$00,$FF,$FF,$FF,$FF,'~',$01
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$F3
	DC.B	$00,$0F,$00,$0F,$00,$00,$FF,$F0
	DC.B	$FF,$F0,$FF,$E0,$C0,$00,$C0,$00
	DC.B	$00,$00,'?',$FF,' ',$00,$1F,$FF
	DC.B	'?',$FF,'?',$FF,$00,$00,$C0,$00
	DC.B	'@',$00,$80,$00,$FC,$00,$FC,$00
	DC.B	$00,$00,$03,$FF,$03,$FF,$01,$F9
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FE,$00
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$7F,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FD
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8
	DC.B	$FF,$F8,$FF,$F0,$C0,$00,$C0,$00
	DC.B	$00,$00,'?',$FF,' ',$00,$1F,$FF
	DC.B	'?',$FF,'?',$FF,$00,$00,$C0,$00
	DC.B	'@',$00,$80,$00,$FC,$00,$FC,$00
	DC.B	$00,$00,$03,$FF,$03,$FF,$01,$E7
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FC,$00
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$7F,$FF
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FE
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8
	DC.B	$FF,$F8,$FF,$F0,$C0,$00,$C0,$00
	DC.B	$00,$00,'?',$FF,' ',$00,$1F,$FF
	DC.B	$1F,$FF,$1F,$FF,$00,$00,$E0,$00
	DC.B	' ',$00,$C0,$00,$FE,$00,$FE,$00
	DC.B	$00,$00,$01,$FF,$01,$FF,$00,$9F
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$F8,$00
	DC.B	$00,$00,$FF,$FF,$FF,$FF,'?',$FE
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$07,$FF
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8
	DC.B	$FF,$F8,$7F,$F0,$E0,$00,$E0,$00
	DC.B	$00,$00,$1F,$FF,$10,$00,$0F,$FF
	DC.B	$1F,$FF,$1F,$FF,$00,$00,$E0,$00
	DC.B	' ',$00,$C0,$00,$FE,$00,$FE,$00
	DC.B	$00,$00,$01,$FF,$01,$FF,$00,$7F
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$F8,' '
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$00,$FC
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$03,$FF
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8
	DC.B	$FF,$F8,$7F,$F0,$E0,$00,$E0,$00
	DC.B	$00,$00,$1F,$FF,$10,$00,$0F,$FF 
	DC.B	$1F,$FF,$1F,$FF,$00,$00,$E0,$00 
	DC.B	' ',$00,$C0,$00,$F8,$00,$F8,$00 
	DC.B	$00,$00,$07,$FF,$07,$FF,$01,$FF 
	DC.B	$00,'?',$FF,$C0,$FF,$FF,$FC,'?' 
	DC.B	$DF,$00,' ',$FF,$FF,$FF,$DF,$00 
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$03,$FF 
	DC.B	$00,$03,$00,$03,$00,$00,$FF,$FC 
	DC.B	$FF,$FC,$BF,$F8,$E0,$00,$E0,$00 
	DC.B	$00,$00,$1F,$FF,$10,$00,$0F,$FF 
	DC.B	$1F,$FF,$1F,$FF,$00,$00,$E0,$00 
	DC.B	' ',$00,$C0,$00,$F0,$00,$F0,$00 
	DC.B	$00,$00,$0F,$FF,$0F,$FF,$07,$FF 
	DC.B	$00,$7F,$FF,$80,$FF,$FF,$00,$7F 
	DC.B	$DF,$F0,' ',$0F,$FF,$FF,$DF,$F0 
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$01,$FF 
	DC.B	$00,$03,$00,$03,$00,$00,$FF,$FC 
	DC.B	$FF,$FC,$DF,$F8,$F8,'?',$F8,'?' 
	DC.B	$00,$00,$07,$C0,$07,$C0,$00,$00 
	DC.B	$E0,$00,$E0,$00,$00,$00,$1F,$FF 
	DC.B	$10,$00,$0F,$FF,$1F,$FF,$1F,$FF 
	DC.B	$00,$00,$E0,$00,' ',$00,$C0,$00 
	DC.B	$E0,$00,$E0,$00,$00,$00,$1F,$FF 
	DC.B	$1F,$FF,$0F,$FC,$1C,$7F,'#',$80 
	DC.B	$FF,$FF,$DC,$7F,$FF,$E0,$00,$1F 
	DC.B	$FF,$FF,$FF,$E0,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$00,$FF,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$FF,$FC,$DF,$F8 
	DC.B	$E0,$0F,$E0,$0F,$00,$00,$1F,$F0 
	DC.B	$18,'0',$07,$C0,$F0,$00,$F0,$00 
	DC.B	$00,$00,$0F,$FF,$08,$00,$07,$FF 
	DC.B	$0F,$FF,$0F,$FF,$00,$00,$F0,$00 
	DC.B	$10,$00,$E0,$00,$E0,$00,$E0,$00 
	DC.B	$00,$00,$1F,$FC,$1F,$FF,$0F,$F3 
	DC.B	'<',$7F,'C',$80,$FF,$FF,$BC,$7F 
	DC.B	$FF,$C7,$00,'8',$FF,$FF,$FF,$C7 
	DC.B	$E0,$00,$1F,$FF,$FF,$FF,$E0,$FF 
	DC.B	$00,$03,$00,$03,$00,$00,$FF,$FC 
	DC.B	$FF,$FC,$EF,$F8,$C0,$07,$C0,$07 
	DC.B	$00,$00,'?',$F8,' ',$08,$1F,$F0 
	DC.B	$F0,$00,$F0,$00,$00,$00,$0F,$FF 
	DC.B	$08,$00,$07,$FF,$0F,$FF,$0F,$FF 
	DC.B	$00,$00,$F0,$00,$10,$00,$E0,$00 
	DC.B	$C0,$00,$C0,$00,$00,$00,'?',$F0 
	DC.B	'?',$FF,$1F,$EF,'~',$FF,$81,$00 
	DC.B	$FF,$FF,'~',$FF,$FF,$DF,$00,' ' 
	DC.B	$FF,$FF,$FF,$DF,$F0,$00,$0F,$FF 
	DC.B	$FF,$FF,$F1,$FF,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$FF,$FC,$EF,$F8 
	DC.B	$80,$01,$80,$01,$00,$00,$7F,$FE 
	DC.B	'@',$06,'?',$F8,$F0,$00,$F0,$00 
	DC.B	$00,$00,$0F,$FF,$08,$00,$07,$FF 
	DC.B	$0F,$1F,$0F,$1F,$00,$00,$F0,$E0 
	DC.B	$10,$E0,$E0,$00,$C0,$00,$C0,$00 
	DC.B	$00,$00,'?',$E0,'?',$FF,$1F,$DF 
	DC.B	'~',$FF,$81,$00,$FF,$FF,'~',$FF 
	DC.B	$FF,$DF,$00,' ',$FF,$FF,$FF,$DF 
	DC.B	$F0,$00,$0F,$FF,$FF,$FF,$F0,$7F 
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8 
	DC.B	$FF,$F8,$F7,$F0,$80,$00,$80,$00 
	DC.B	$00,$00,$7F,$FF,'@',$01,'?',$FE 
	DC.B	$F8,$00,$F8,$00,$00,$00,$07,$FF 
	DC.B	$04,$00,$03,$FF,$0C,$07,$0C,$07 
	DC.B	$00,$00,$F3,$F8,$13,$18,$E0,$E0 
	DC.B	$C0,$00,$C0,$00,$00,$00,'?',$C1 
	DC.B	'?',$FF,$1F,$BE,$FF,$C7,$00,'8' 
	DC.B	$FF,$FF,$FF,$C7,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$F1,$80,$0E,$7F 
	DC.B	$FF,$FF,$F1,$BF,$00,$07,$00,$07 
	DC.B	$00,$00,$FF,$F8,$FF,$F8,$F7,$F0 
	DC.B	$80,$00,$80,$00,$00,$00,$7F,$FF 
	DC.B	'@',$00,'?',$FF,'x',$00,'x',$00 
	DC.B	$00,$00,$87,$FF,$84,$00,$03,$FF 
	DC.B	$00,$03,$00,$03,$00,$00,$FF,$FC 
	DC.B	$1C,$04,$E3,$F8,$E0,$00,$E0,$00 
	DC.B	$00,$00,$1F,$81,$1F,$FF,$0F,'~' 
	DC.B	$FF,$BB,$00,'|',$FF,$FF,$FF,$BB 
	DC.B	$FF,$C7,$00,'8',$FF,$FF,$FF,$C7 
	DC.B	$F1,$C0,$0E,'?',$FF,$FF,$F1,$DF 
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8 
	DC.B	$FF,$F8,$FB,$F0,$00,$00,$FF,$FF 
	DC.B	$80,$00,$7F,$FF,'<',$00,'<',$00 
	DC.B	$00,$00,$C3,$FF,'B',$00,$81,$FF 
	DC.B	$00,$01,$00,$01,$00,$00,$FF,$FE 
	DC.B	$10,$02,$EF,$FC,$F0,$00,$F0,$00 
	DC.B	$00,$01,$0F,$82,$0F,$FF,$03,'}' 
	DC.B	$FF,'}',$00,$FE,$FF,$FF,$FF,'}' 
	DC.B	$FF,$BB,$00,'|',$FF,$FF,$FF,$BB 
	DC.B	$FB,$E0,$04,$1F,$FF,$FF,$FB,$E7 
	DC.B	$00,$0F,$00,$0F,$00,$00,$FF,$F0 
	DC.B	$FF,$F0,$FB,$E0,$00,$00,$FF,$FF 
	DC.B	$80,$00,$7F,$FF,$1C,$00,$1C,$00 
	DC.B	$00,$00,$E3,$FF,'"',$00,$C1,$FF 
	DC.B	$00,$00,$FF,$FF,' ',$01,$DF,$FE 
	DC.B	$FC,$00,$FC,$00,$00,$01,$03,$02 
	DC.B	$03,$FF,$00,$FD,$FE,$FE,$01,$FF 
	DC.B	$FF,$FF,$FE,$FE,$FF,'}',$00,$FE 
	DC.B	$FF,$FF,$FF,'}',$FB,$F8,$04,$07 
	DC.B	$FF,$FF,$FB,$FB,$00,$0F,$00,$0F 
	DC.B	$00,$00,$FF,$F0,$FF,$F0,$FD,$E0 
	DC.B	$00,$00,$FF,$FF,$80,$00,$7F,$FF 
	DC.B	$0E,$00,$0E,$00,$00,$00,$F1,$FF 
	DC.B	$11,$00,$E0,$FF,$00,$00,$FF,$FF 
	DC.B	'@',$00,$BF,$FF,'~',$00,'~',$00 
	DC.B	$00,$03,$81,$04,$81,$FF,$00,$FB 
	DC.B	$FE,$FE,$01,$FF,$FF,$FF,$FE,$FE 
	DC.B	$FF,'~',$00,$FF,$FF,$FF,$FF,'~' 
	DC.B	$FF,$F8,$00,$07,$FF,$FF,$FF,$F9 
	DC.B	$00,$1F,$00,$1F,$00,$00,$FF,$E0 
	DC.B	$FF,$E0,$FD,$80,$00,$00,$FF,$FF 
	DC.B	$80,$00,$7F,$FF,$06,$00,$06,$00 
	DC.B	$00,$00,$F9,$FF,$09,$00,$F0,$FF 
	DC.B	$00,$00,$FF,$FF,$80,$00,$7F,$FF 
	DC.B	'~',$00,'~',$00,$00,$03,$81,$04 
	DC.B	$81,$FF,$00,$FB,$FD,$FF,$03,$FF 
	DC.B	$FF,$FF,$FD,$FF,'~',$FE,$81,$FF 
	DC.B	$FF,$FF,'~',$FE,$FF,$F8,$00,$05 
	DC.B	$FF,$FF,$FF,$FA,$00,$7F,$00,$7F 
	DC.B	$00,$00,$FF,$80,$FF,$80,$FE,$00 
	DC.B	$80,$00,$80,$00,$00,$00,$7F,$FF 
	DC.B	'@',$00,'?',$FF,$00,$00,$FF,$FF 
	DC.B	$07,$80,$F8,$7F,$00,$00,$FF,$FF 
	DC.B	$80,$00,$7F,$FF,'<',$00,'<',$00 
	DC.B	$00,$03,$C2,$04,'C',$FF,$81,$FB 
	DC.B	$FD,$FF,$03,$FF,$FF,$FF,$FD,$FF 
	DC.B	'~',$FF,$81,$FF,$FF,$FF,'~',$FF 
	DC.B	$7F,$F8,$80,$05,$FF,$FF,$7F,$FA 
	DC.B	$00,$FF,$00,$FF,$00,$00,$FF,$00 
	DC.B	$FF,$00,$FE,$00,$80,$00,$80,$00 
	DC.B	$00,$00,$7F,$FF,'@',$00,'?',$FF 
	DC.B	$00,$00,$FF,$FF,$01,$81,$FE,'~' 
	DC.B	$00,$00,$FF,$FF,$00,$03,$FF,$FC 
	DC.B	$1C,$00,$1C,$00,$00,$01,$E2,$02 
	DC.B	$E3,$FF,$01,$FD,$FB,$E1,$07,$E1 
	DC.B	$FF,$E1,$FB,$FF,'~',$FF,$81,$FF 
	DC.B	$FF,$FF,'~',$FF,$7F,$F8,$80,$04 
	DC.B	$FF,$FF,$7F,$FB,$00,$FF,$00,$FF 
	DC.B	$00,$00,$FF,$00,$FF,$00,'~',$00 
	DC.B	$FF,$83,$FF,$83,$00,$00,$00,'|' 
	DC.B	$00,'|',$00,$00,$C0,$00,$C0,$00 
	DC.B	$00,$00,'?',$FF,' ',$00,$1F,$FF 
	DC.B	$00,$00,$FF,$FF,$00,$C2,$FF,'=' 
	DC.B	$00,$03,$FF,$FC,$00,'?',$FF,$C3 
	DC.B	$0C,$00,$0C,$00,$E0,$01,$12,$02 
	DC.B	$F3,$FF,$E1,$FD,$FB,$80,$07,$80 
	DC.B	$FF,$80,$FB,$FF,'}',$1F,$83,$1F 
	DC.B	$FF,$1F,'}',$FF,$BF,$F8,$C0,$04 
	DC.B	$FF,$FF,$BF,$FB,$00,$FF,$00,$FF 
	DC.B	$00,$00,$7F,$00,$FF,$00,$BE,$00 
	DC.B	$FC,$00,$FC,$00,$00,$00,$03,$FF 
	DC.B	$03,$83,$00,'|?',$FF,'?',$FF
	DC.B	$00,$00,$C0,$00,$C0,$00,$00,$00 
	DC.B	$E0,$00,$E0,$00,$00,$00,$1F,$FF 
	DC.B	$18,$00,$07,$FF,$00,$00,$FF,$FF 
	DC.B	$00,'D',$FF,$BB,$00,'?',$FF,$C0 
	DC.B	$01,$FF,$FE,'?',$F0,$01,$0C,$02 
	DC.B	$FF,$FF,$F3,$FD,$FB,$00,$07,$1E 
	DC.B	$FF,$1E,$FB,$E1,'|',$07,$82,$07 
	DC.B	$FE,$07,'}',$FF,$BF,$F8,$C0,$04 
	DC.B	$FF,$FF,$BF,$FB,$00,$7F,$00,$7F 
	DC.B	$00,$00,$7F,$80,$FF,$80,$BF,$00 
	DC.B	$F0,$00,$F0,$00,$00,$00,$0F,$FF 
	DC.B	$0C,$00,$03,$FF,$1F,$FF,$1F,$FF 
	DC.B	$00,$00,$E0,$00,' ',$00,$C0,$00 
	DC.B	$F8,$00,$F8,$00,$00,$00,$07,$FF 
	DC.B	$06,$00,$01,$FF,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,$FF,$FF,$00 
	DC.B	$01,$FF,$FE,$FF,$F8,$00,$04,$01 
	DC.B	$FF,$FF,$FB,$FE,$F7,$00,$0F,'?' 
	DC.B	$FF,'?',$F7,$C0,'|',$03,$82,$C3 
	DC.B	$FE,$C3,'}?',$BF,$F8,$C0,$04
	DC.B	$FF,$FF,$BF,$FB,$00,$7F,$00,$7F 
	DC.B	$00,$00,'?',$80,$FF,$80,$DF,$00 
	DC.B	$E0,$00,$E0,$00,$00,$00,$1F,$FF 
	DC.B	$10,$80,$0F,$7F,$0F,$FF,$0F,$FF 
	DC.B	$00,$00,$F0,$00,$10,$00,$E0,$00 
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF 
	DC.B	$01,$80,$00,$7F,$00,$00,$FF,$FF 
	DC.B	$00,$08,$FF,$F7,$01,$FF,$FE,$00 
	DC.B	$03,$FF,$FD,$FF,$F8,$00,$04,$01 
	DC.B	$FF,$FF,$FB,$FE,$F7,$00,$0F,'?' 
	DC.B	$FF,'?',$F7,$C0,'x',$03,$87,$F3 
	DC.B	$FF,$F3,'x',$0F,$DF,$F8,$E0,$04 
	DC.B	$FF,$FF,$DF,$FB,$00,$7F,$00,$7F 
	DC.B	$00,$00,'?',$80,$FF,$80,$DF,$00 
	DC.B	$80,$00,$80,$00,$00,$00,$7F,$FF 
	DC.B	'a',$00,$1E,$FF,$0F,$FF,$0F,$FF 
	DC.B	$00,$00,$F0,$00,$10,$00,$E0,$00 
	DC.B	$FF,$80,$FF,$80,$00,$00,$00,$7F 
	DC.B	$00,'`',$00,$1F,$00,$00,$FF,$FF 
	DC.B	$00,$08,$FF,$F7,$01,$FF,$FE,$00 
	DC.B	$03,$FF,$FD,$FF,$FC,$00,$02,$81 
	DC.B	$FF,$FF,$FD,'~',$F6,$04,$0E,$7F 
	DC.B	$FE,$7F,$F7,$84,'x',$01,$87,$F1 
	DC.B	$FF,$F1,'x',$0F,$DF,$F0,$E0,$08 
	DC.B	$FF,$FF,$DF,$F7,$00,$7F,$00,$7F 
	DC.B	$00,$00,$1F,$80,$FF,$80,$EF,$00 
	DC.B	$00,$00,$FF,$FF,$86,$00,'y',$FF 
	DC.B	$07,$FF,$07,$FF,$00,$00,$F8,$00 
	DC.B	$08,$00,$F0,$00,$FF,$E0,$FF,$E0 
	DC.B	$00,$00,$00,$1F,$00,$18,$00,$07 
	DC.B	$00,$00,$FF,$FF,$00,$08,$FF,$F7 
	DC.B	$03,$FF,$FC,$00,$07,$FF,$FB,$FF 
	DC.B	$FC,$00,$02,$C0,$FF,$FF,$FD,'?' 
	DC.B	'v',$0C,'',$7F,$FE,$7F,'w',$8C 
	DC.B	'xA',$87,$F9,$FF,$F9,'xG' 
	DC.B	$DF,$F0,$E0,$08,$FF,$FF,$DF,$F7 
	DC.B	$00,$FE,$00,$FE,$00,$00,$1F,$01 
	DC.B	$FF,$01,$EE,$00,$00,$00,$FF,$FF 
	DC.B	$08,$00,$F7,$FF,$07,$FF,$07,$FF 
	DC.B	$00,$00,$F8,$00,$08,$00,$F0,$00 
	DC.B	$FF,$F8,$FF,$F8,$00,$00,$00,$07 
	DC.B	$00,$06,$00,$01,$00,$00,$FF,$FF 
	DC.B	$07,$C4,$F8,';',$03,$FC,$FC,$03 
	DC.B	$07,$FF,$FB,$FC,$FC,$00,$02,$C0 
	DC.B	$FF,$FF,$FD,'?v',$0C,'',$7F
	DC.B	$FE,$7F,'w',$8C,$F8,$C1,$07,$F9 
	DC.B	$FF,$F9,$F8,$C7,$DF,$F0,$E0,$08 
	DC.B	$FF,$FF,$DF,$F7,$01,$FC,$01,$FC 
	DC.B	$00,$00,$1E,$03,$FE,$02,$E0,$01 
	DC.B	$00,$00,$FF,$FF,$10,$00,$EF,$FF 
	DC.B	$0F,$FF,$0F,$FF,$00,$00,$F0,$00 
	DC.B	$10,$00,$E0,$00,$FF,$FE,$FF,$FE 
	DC.B	$00,$00,$00,$01,$00,$01,$00,$00 
	DC.B	$00,$00,$FF,$FF,$B8,'<G',$C3
	DC.B	$03,$FF,$FC,$00,$07,$FF,$FB,$FF 
	DC.B	'|',$00,$82,$E1,$FF,$FF,'}',$1E 
	DC.B	$F6,$04,$0E,'?',$FE,'?',$F7,$C4 
	DC.B	$F8,$C1,$07,$F9,$FF,$F9,$F8,$C7 
	DC.B	$DF,$F0,$E0,$08,$FF,$FF,$DF,$F7 
	DC.B	$0F,$FC,$0F,$FC,$00,$00,$10,$03 
	DC.B	$F0,$02,$E0,$01,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$01,$FF,$01,$FF 
	DC.B	$00,$00,$FE,$00,$0E,$00,$F0,$00 
	DC.B	$00,$00,$FF,$FF,$C0,$04,'?',$FB 
	DC.B	$07,$FF,$F8,$00,$0F,$FF,$F7,$FF 
	DC.B	$BB,$00,'D',$F1,$FE,$FF,$BB,$0E 
	DC.B	$F7,$00,$0F,'?',$FF,'?',$F7,$C0 
	DC.B	$F8,'A',$07,$F9,$FF,$F9,$F8,'G' 
	DC.B	$BF,$E0,$C0,$10,$FF,$FF,$BF,$EF 
	DC.B	$0F,$FC,$0F,$FC,$00,$00,$10,$03 
	DC.B	$F0,$03,$E0,$00,$00,$00,$FF,$FF 
	DC.B	$FE,$00,$01,$FF,$00,'?',$00,'?' 
	DC.B	$00,$00,$FF,$C0,$09,$C0,$F6,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,$02,$FF,$FD,$07,$FF,$F8,$00 
	DC.B	$0F,$FF,$F7,$FF,$97,$01,'h',$F2 
	DC.B	$FE,$FF,$97,$0D,$FB,$00,$07,$1F 
	DC.B	$FF,$1F,$FB,$E0,$FC,$03,$03,$F3 
	DC.B	$FF,$F3,$FC,$0F,$BF,$E0,$C0,$10 
	DC.B	$FF,$FF,$BF,$EF,$0F,$F8,$0F,$F8 
	DC.B	$00,$00,$10,$07,$F0,$04,$E0,$03 
	DC.B	$00,$00,$FF,$FF,$01,$80,$FE,$7F 
	DC.B	$00,$0F,$00,$0F,$00,$00,$FF,$F0 
	DC.B	$10,'0',$EF,$C0,$FF,$FE,$FF,$FE 
	DC.B	$00,$00,$00,$01,$00,$01,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$03,$FF,$FC 
	DC.B	$07,$FF,$F8,$00,$0F,$FF,$F7,$FF 
	DC.B	$CF,$01,'0',$FA,$FE,$FF,$CF,$05 
	DC.B	$FB,$80,$07,$FF,$FF,$FF,$FB,$80 
	DC.B	$FC,$03,$03,$F3,$FF,$F3,$FC,$0F 
	DC.B	$BF,$80,$C0,'`',$FF,$FF,$BF,$9F 
	DC.B	$01,$F0,$01,$F0,$00,$00,$1E,$0F 
	DC.B	$FE,$08,$E0,$07,$00,$00,$FF,$FF 
	DC.B	$00,'`',$FF,$9F,$00,$07,$00,$07 
	DC.B	$00,$00,$FF,$F8,' ',$08,$DF,$F0 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	$00,$01,$FF,$FE,$07,$FC,$F8,$03 
	DC.B	$CF,$FF,'7',$FC,$0F,$83,$F0,'|' 
	DC.B	$FE,$7F,$0F,$83,$FB,$BF,$07,$C0 
	DC.B	$FF,$FF,$FB,$BF,$F0,$07,$0F,$C7 
	DC.B	$FF,$C7,$F0,'?~',$00,$81,$80
	DC.B	$FF,$FF,'~',$7F,$00,'p',$00,'p' 
	DC.B	$1E,$00,'!',$8F,$FF,$88,$DE,$07 
	DC.B	$00,$00,$FF,$FF,$00,$18,$FF,$E7 
	DC.B	$00,$03,$00,$03,$00,$00,$FF,$FC 
	DC.B	'@',$04,$BF,$F8,$FF,$FC,$FF,$FC 
	DC.B	$00,$00,$00,$03,$00,$02,$00,$01 
	DC.B	$00,$00,$FF,$FF,$00,$01,$FF,$FE 
	DC.B	$07,$F3,$F8,$0C,'?',$FF,$C7,$F3 
	DC.B	$9F,$80,'`',$7F,$FE,$7F,$9F,$80 
	DC.B	$FD,'?',$03,$C0,$FF,$FF,$FD,'?' 
	DC.B	$FC,$1E,$03,$FF,$FF,$FF,$FC,$1E 
	DC.B	$FE,$00,$01,$08,$FF,$FF,$FE,$F7 
	DC.B	$00,' ',$00,' ',$1F,$80,' _'
	DC.B	$FF,$D0,$DF,$8F,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$80,$04,$7F,$F8 
	DC.B	$FF,$F8,$FF,$F8,$00,$00,$00,$07 
	DC.B	$00,$04,$00,$03,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$03,$FF,$FC,$00 
	DC.B	$8F,$FF,'s',$FF,$DF,$80,' ',$7F 
	DC.B	$FF,$7F,$DF,$80,'|',$FF,$83,$00 
	DC.B	$FF,$FF,'|',$FF,$FF,$C9,$00,'>' 
	DC.B	$FF,$FF,$FF,$C9,$FE,$00,$01,'8' 
	DC.B	$FF,$FF,$FE,$C7,$1F,$C0,' ?'
	DC.B	$FF,$E0,$DF,$DF,$00,$00,$FF,$FF 
	DC.B	$00,$03,$FF,$FC,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$F8,$FF,$F8,$00,$00,$00,$07 
	DC.B	$00,$04,$00,$03,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$03,$FF,$FC,$00 
	DC.B	$8F,$FF,'s',$FF,$DF,$80,' ',$7F 
	DC.B	$FF,$7F,$DF,$80,$1E,$FF,$E1,$00 
	DC.B	$FF,$FF,$1E,$FF,$FF,$F7,$00,$08 
	DC.B	$FF,$FF,$FF,$F7,$FE,$00,$01,$F8 
	DC.B	$FF,$FF,$FE,$07,'?',$C0,'@?'
	DC.B	$FF,$F0,$BF,$CF,$00,$00,$FF,$FF 
	DC.B	$00,$02,$FF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	$07,$C0,$F8,'?',$03,$FF,$FC,$00 
	DC.B	$8F,$FF,'s',$FF,$BF,$C0,'@?'
	DC.B	$FF,'?',$BF,$C0,$05,$FF,$FA,$00 
	DC.B	$FF,$FF,$05,$FF,$FF,$F7,$00,$08 
	DC.B	$FF,$FF,$FF,$F7,$FC,$00,$03,$FA 
	DC.B	$FF,$FF,$FC,$05,$7F,$E0,$80,$1F 
	DC.B	$FF,$F0,$7F,$EF,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	$18,'1',$E7,$CE,$01,$FF,$FE,$00 
	DC.B	$0F,$FF,$F1,$FF,$BF,$E0,'@',$1F 
	DC.B	$FF,$1F,$BF,$E0,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$01,$FF,$FF,$FB,$00,$04 
	DC.B	$FF,$FF,$FF,$FB,$F0,$00,$0F,$F3 
	DC.B	$FF,$FF,$F0,$0C,$FC,$E0,$03,$1F 
	DC.B	$FF,$F0,$FC,$EF,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	'`',$09,$9F,$F6,$01,$FF,$FE,$00 
	DC.B	$07,$FF,$F9,$FF,$BF,$E0,'@',$1F 
	DC.B	$FF,$9F,$BF,$E0,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$01,$FF,$FF,$F9,$00,$06 
	DC.B	$FF,$FF,$FF,$F9,$C0,$02,'?',$F5 
	DC.B	$FF,$FD,$C0,$0A,$FB,$E0,$04,$1F 
	DC.B	$FF,$F0,$FB,$EF,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$FF 
	DC.B	$80,$08,$7F,$F7,$00,$FF,$FF,$00 
	DC.B	$03,$FF,$FC,$FF,$BF,$E0,'@',$1F 
	DC.B	$FF,$9F,$BF,$E0,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$01,$FF,$FF,$F9,$00,$06 
	DC.B	$FF,$FF,$FF,$F9,$00,$06,$FF,$F9 
	DC.B	$FF,$F9,$00,$06,$E7,$F0,$18,$0F 
	DC.B	$FF,$F8,$E7,$F7,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,$7F,$FF,$80 
	DC.B	$00,$FF,$FF,$7F,$BF,$E0,'@',$1F 
	DC.B	$FF,$DF,$BF,$E0,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$01,$FF,$FF,$F8,$00,$07 
	DC.B	$FF,$FF,$FF,$F8,$00,$0F,$FF,$F0 
	DC.B	$FF,$F1,$00,$0F,'O',$F0,$B0,$0F 
	DC.B	$FF,$F8,'O',$F7,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,'?',$FF,$C0 
	DC.B	$00,$7F,$FF,$BF,$BF,$E0,'@',$1F 
	DC.B	$FF,$DF,$BF,$E0,$00,$FF,$FF,$00 
	DC.B	$FF,$FF,$00,$FF,$FF,$F0,$00,$0F 
	DC.B	$FF,$FF,$FF,$F0,$00,$1F,$FF,$E0 
	DC.B	$FF,$E3,$00,$1F,$1C,$F0,$E3,$0F 
	DC.B	$FF,$F8,$1C,$F7,$00,$00,$FF,$FF 
	DC.B	'@',$02,$BF,$FD,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,$0F,$FF,$F0 
	DC.B	$00,'?',$FF,$CF,$9F,$F0,'`',$0F 
	DC.B	$FF,$CF,$9F,$F0,$00,$FF,$FF,$00 
	DC.B	$FF,$FF,$00,$FF,$FF,$F0,$00,$0F 
	DC.B	$FF,$FF,$FF,$F0,$00,'?',$FF,$C0 
	DC.B	$FF,$C7,$00,'?s',$F0,$8C,$0F
	DC.B	$FF,$F8,'s',$F7,$00,$00,$FF,$FF 
	DC.B	'@',$06,$BF,$F9,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$0A,$FF,$F4 
	DC.B	$FF,$FC,$FF,$FC,$00,$00,$00,$03 
	DC.B	$00,$02,$00,$01,$00,$00,$FF,$FF 
	DC.B	$00,$04,$FF,$FB,$00,$03,$FF,$FC 
	DC.B	$00,$0F,$FF,$F3,$1F,$F0,$E0,$0F 
	DC.B	$FF,$CF,$1F,$F0,$00,$7F,$FF,$80 
	DC.B	$FF,$FF,$00,$7F,$FF,$E0,$00,$1F 
	DC.B	$FF,$FF,$FF,$E0,$00,'?',$FF,$C0 
	DC.B	$FF,$CF,$00,'?',$0F,$F0,$F0,$0F 
	DC.B	$FF,$F8,$0F,$F7,$00,$00,$FF,$FF 
	DC.B	' ',$06,$DF,$F9,$00,$00,$FF,$FF 
	DC.B	$00,'1',$FF,$CE,$FF,$FE,$FF,$FE 
	DC.B	$00,$00,$00,$01,$00,$01,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$04,$FF,$FB 
	DC.B	$00,$00,$FF,$FF,$01,$03,$FE,$FC 
	DC.B	$1F,$FC,$E0,$03,$FF,$E3,$1F,$FC 
	DC.B	$00,$0F,$FF,$F0,$FF,$FF,$00,$0F 
	DC.B	$FF,$00,$00,$FF,$FF,$FF,$FF,$00 
	DC.B	$00,$7F,$FF,$80,$FF,$8F,$00,$7F 
	DC.B	'?',$F8,$C0,$07,$FF,$FC,'?',$FB 
	DC.B	$00,$00,$FF,$FF,$10,$05,$EF,$FA 
	DC.B	$00,$00,$FF,$FF,$00,'A',$FF,$BE 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,$18,$FF,$E7,$00,$00,$FF,$FF 
	DC.B	$02,$03,$FD,$FD,$0F,$FF,$F0,$00 
	DC.B	$FF,$E0,$0F,$FF,$80,$00,$7F,$FF 
	DC.B	$7F,$FF,$80,$00,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$03,$FF,$FC,$00 
	DC.B	$FC,$1F,$03,$FF,$7F,$F8,$80,$07 
	DC.B	$FF,$FC,$7F,$FB,$00,$00,$FF,$FF 
	DC.B	$10,$08,$EF,$F7,$00,$00,$FF,$FF 
	DC.B	$FF,$81,$00,'~',$00,$00,$FF,$FF 
	DC.B	$80,'`',$7F,$9F,$00,$00,$FF,$FF 
	DC.B	$0C,$03,$F3,$FD,$0F,$FF,$F0,$00 
	DC.B	$FF,$F0,$CF,$FF,$E0,$00,$1F,$FF 
	DC.B	$1F,$FF,$E0,$00,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$03,$FE,$FC,$01 
	DC.B	$FC,'?',$03,$FE,$FF,$F0,$00,$0F 
	DC.B	$FF,$FC,$FF,$F3,$00,$00,$FF,$FF 
	DC.B	$0C,'0',$F3,$CF,$00,$00,$FF,$FF 
	DC.B	$80,$01,$7F,$FE,$80,$00,$80,$00 
	DC.B	$00,$00,$7F,$FF,'@',$00,'?',$FF 
	DC.B	$00,$00,$FF,$FF,'0',$07,$CF,$FB 
	DC.B	$0F,$FF,$F0,$00,$FF,$FC,$EF,$FF 
	DC.B	$E0,$00,$1F,$FF,$1F,$FF,$E0,$00 
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$03,$FE,$FC,$01,$FD,$FF,$03,$FE 
	DC.B	$FF,$F0,$00,$0F,$FF,$F8,$FF,$F7 
	DC.B	$00,$00,$FF,$FF,$03,$C1,$FC,'>' 
	DC.B	$00,$00,$FF,$FF,$00,$01,$FF,$FE 
	DC.B	$C0,$00,$C0,$00,$00,$00,'?',$FF 
	DC.B	'0',$00,$0F,$FF,$00,$00,$FF,$FF 
	DC.B	'@',$07,$BF,$FB,$07,$FF,$F8,$00 
	DC.B	$FF,$FF,$E7,$FF,$E0,$00,$1F,$FF 
	DC.B	$9F,$FF,$E0,$00,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$07,$FE,$F8,$01 
	DC.B	$F9,$FF,$07,$FE,$FF,$E0,$00,$1F 
	DC.B	$FF,$F0,$FF,$EF,$00,$00,$FF,$FF 
	DC.B	$00,$01,$FF,$FE,$00,$00,$FF,$FF 
	DC.B	$00,$01,$FF,$FE,$F0,$00,$F0,$00 
	DC.B	$00,$00,$0F,$FF,$0E,$01,$01,$FE 
	DC.B	$00,$00,$FF,$FF,$80,$1F,$7F,$E7 
	DC.B	$07,$FF,$F8,$00,$FF,$FF,$F7,$FF 
	DC.B	$C0,$00,'7',$FF,$FF,$FF,$C8,$00 
	DC.B	$00,$00,$FF,$EF,$FF,$FF,$00,$10 
	DC.B	$1F,$FE,$E0,$01,$E3,$FF,$1F,$FE 
	DC.B	$FF,$80,$00,$7F,$FF,$E0,$FF,$9F 
	DC.B	$00,$00,$FF,$FF,$00,$02,$FF,$FD 
	DC.B	$00,$00,$FF,$FF,$00,$01,$FF,$FE 
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF 
	DC.B	$01,$FF,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,'?',$FF,$DF,$03,$FF,$FC,$00 
	DC.B	$FF,$FF,$FB,$FF,$E0,$00,$13,$F8 
	DC.B	$FF,$FF,$EC,$07,$00,$00,$FF,$C7 
	DC.B	$FF,$FF,$00,'8',$FF,$FD,$00,$02 
	DC.B	$07,$FF,$FF,$FD,$FF,$80,$00,$7F 
	DC.B	$FF,$E0,$FF,$9F,$00,$00,$FF,$FF 
	DC.B	$00,$02,$FF,$FD,$00,$00,$FF,$FF 
	DC.B	$00,$01,$FF,$FE,$00,$00,$FF,$FF 
	DC.B	$F0,$7F,$0F,$BF,$03,$FF,$FC,$00 
	DC.B	$FF,$FF,$FB,$FF,$E0,$00,$10,$00 
	DC.B	$FF,$FF,$EF,$FF,$00,$07,$7F,$C8 
	DC.B	$FF,$F8,$80,'7',$FF,$FD,$00,$02 
	DC.B	$1F,$FF,$FF,$FD,$FF,$80,$00,$7F 
	DC.B	$FF,$D0,$FF,$AF,$00,$00,$FF,$FF 
	DC.B	$00,$02,$FF,$FD,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$00,$02,$FF,$FC 
	DC.B	$F0,$00,$F0,$00,$00,$00,$0F,$FF 
	DC.B	$0D,$FF,$02,$7F,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$FD,$FF,$F0,$00,$08,$1F 
	DC.B	$FF,$FF,$F7,$E0,$00,$0F,$FF,$90 
	DC.B	$FF,$F0,$00,'o',$FF,$FD,$00,$02 
	DC.B	$7F,$FF,$FF,$FD,$FF,$00,$00,$FF 
	DC.B	$FF,$8C,$FF,'s',$00,$00,$FF,$FF 
	DC.B	$00,$01,$FF,$FE,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FC,$00,$FC,$00,$00,$00,$03,$FF 
	DC.B	$03,$FF,$01,$FF,$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$FD,$FF,$F8,$00,$04,'?' 
	DC.B	$FF,$FF,$FB,$DF,$00,$1F,$FC,' ' 
	DC.B	$FF,$FF,$C3,$DF,$FF,$F8,$00,$07 
	DC.B	$FF,$FF,$FF,$F8,$FC,$00,$03,$FF 
	DC.B	$FF,$03,$FC,$FC,$00,$00,$FF,$FF 
	DC.B	$F8,$01,$07,$FE,$00,$07,$00,$07 
	DC.B	$00,$00,$FF,$F8,$00,$18,$FF,$E0 
	DC.B	$FC,$00,$FC,$00,$00,$00,$03,$FF 
	DC.B	$03,$FF,$01,$FF,$00,$FF,$FF,$00 
	DC.B	$FF,$FF,$FE,$FF,$FC,$00,$02,$7F 
	DC.B	$FF,$FF,$FD,$BF,$00,'?',$F0,'@' 
	DC.B	$FF,$FF,$EF,$BF,$FF,$F8,$00,$07 
	DC.B	$FF,$FF,$FF,$F9,$00,$00,$FF,$FF 
	DC.B	$FE,$00,$01,$FF,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$00,$0F,$00,$0F 
	DC.B	$00,$00,$FF,$F0,$FF,$F0,$00,$00 
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF 
	DC.B	$01,$FF,$00,$FF,$00,$7F,$FF,$80 
	DC.B	$FF,$FF,$FF,$7F,$FC,$00,$02,$FF 
	DC.B	$FF,$FF,$FD,$7F,$00,$7F,$F8,$80 
	DC.B	$FF,$FF,$F7,$7F,$FF,$F0,$00,$0F 
	DC.B	$FF,$FF,$FF,$F3,$00,$00,$FF,$FF 
	DC.B	$FF,$00,$FE,$FF,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$00,$07,$00,$07 
	DC.B	$00,$00,$FF,$F8,'0',$08,$CF,$F0 
	DC.B	$FE,$00,$FE,$00,$00,$00,$01,$FF 
	DC.B	$01,$FF,$00,$FF,$00,'?',$FF,$C0 
	DC.B	$FF,$FF,$FF,$BF,$FE,$00,$01,$FF 
	DC.B	$FF,$FF,$FE,$FF,$00,$FF,$FD,$00 
	DC.B	$FF,$FF,$FA,$FF,$FF,$E0,$00,$1F 
	DC.B	$FF,$FF,$FF,$EF,$00,$00,$FF,$FF 
	DC.B	$FF,$00,$FE,$FF,$00,$00,$FF,$FF 
	DC.B	'@',$00,$BF,$FF,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$C0,$04,'?',$F8 
	DC.B	$FF,$00,$FF,$00,$00,$00,$00,$FF 
	DC.B	$00,$FF,$00,$7F,$00,$0F,$FF,$B0 
	DC.B	$FF,$BF,$FF,'O',$FF,$00,$00,$FF 
	DC.B	$FF,$FF,$FF,'?',$01,$FF,$FE,$00 
	DC.B	$FF,$FF,$FD,$FF,$FF,$C0,$00,'?' 
	DC.B	$FF,$FF,$FF,$DF,$00,$00,$FF,$FF 
	DC.B	$FF,$80,$FF,$7F,$00,$00,$FF,$FF 
	DC.B	'@',$01,$BF,$FE,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FF,$80,$FF,$80,$00,$00,$00,$7F 
	DC.B	$00,$7F,$00,'?',$00,$03,$FF,$8C 
	DC.B	$FF,$8F,$FF,'s',$FD,$C0,$02,'?' 
	DC.B	$FF,$FF,$FD,$DF,$03,$FF,$FC,$00 
	DC.B	$FF,$FF,$FB,$FF,$FF,$00,$00,$FF 
	DC.B	$FF,$FF,$FF,'?',$00,$00,$FF,$FF 
	DC.B	$FF,$80,$FF,$7F,$00,$00,$FF,$FF 
	DC.B	' ',$01,$DF,$FE,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FF,$C0,$FF,$C0,$00,$00,$00,'?' 
	DC.B	$00,'?',$00,$1F,$00,$00,$FF,$03 
	DC.B	$FF,$03,$FE,$FC,'~',$E0,$81,$1F 
	DC.B	$FF,$FF,'~',$E7,$07,$BF,$F8,'@' 
	DC.B	$FF,$FF,$E7,$BF,$FC,$00,$03,$FF 
	DC.B	$FF,$FF,$FC,$7F,$00,$00,$FF,$FF 
	DC.B	$FF,$C0,$FF,$BF,$00,$00,$FF,$FF 
	DC.B	' ',$01,$DF,$FE,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FF,$E0,$FF,$E0,$00,$00,$00,$1F 
	DC.B	$00,$1F,$00,$0F,$00,$00,$FE,$00 
	DC.B	$FE,$00,$FD,$FF,$0E,$F8,'q',$07 
	DC.B	$7F,$FF,$8E,$F8,$1F,$7F,$E0,$80 
	DC.B	$FF,$FF,$1F,$7F,$F0,$00,$0E,$7F 
	DC.B	$FE,$7F,$F1,$BF,$00,$00,$FF,$FF 
	DC.B	$FF,$C0,$FF,$BF,$00,$00,$FF,$FF 
	DC.B	$10,$01,$EF,$FE,$00,$03,$00,$03 
	DC.B	$00,$00,$FF,$FC,$00,$04,$FF,$F8 
	DC.B	$FF,$F0,$FF,$F0,$00,$00,$00,$0F 
	DC.B	$00,$0F,$00,$07,$00,$00,$FC,$00 
	DC.B	$FC,$00,$FB,$FF,$00,$7F,'?',$80 
	DC.B	'?',$FF,$D0,$7F,$FF,$7F,$00,$80 
	DC.B	$FF,$FF,$FF,$7F,$00,$00,$F8,$7F 
	DC.B	$F8,$7F,$07,$BF,$00,$00,$FF,$FF 
	DC.B	$FF,$E0,$FF,$DF,$00,$01,$00,$01 
	DC.B	$00,$00,$FF,$FE,$10,$02,$EF,$FC 
	DC.B	$00,$07,$00,$07,$00,$00,$FF,$F8 
	DC.B	$80,$08,$7F,$F0,$FF,$F8,$FF,$F8 
	DC.B	$00,$00,$00,$07,$00,$07,$00,$01 
	DC.B	$00,$00,$FC,$00,$FC,$00,$FB,$FF 
	DC.B	$00,$7F,'?',$80,'?',$FF,$DF,$7F 
	DC.B	$FE,$F0,$01,$0F,$FF,$FF,$FE,$F0 
	DC.B	$00,$00,$C0,$7F,$C0,$7F,'?',$BF 
	DC.B	$00,$00,$FF,$FF,$FF,$F0,$FF,$CF 
	DC.B	$10,$03,$10,$03,$00,$00,$EF,$FC 
	DC.B	',',$0C,$C3,$F0,$80,$0F,$80,$0F 
	DC.B	$00,$00,$7F,$F0,'`0',$1F,$C0
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$00,$00,$FF,$80 
	DC.B	$FF,$80,'p',$7F,$00,'?',$7F,$C0 
	DC.B	$7F,$FF,$BF,$BF,$FC,$00,$03,$FF 
	DC.B	$FF,$FF,$FD,$0F,$00,$00,$80,'?' 
	DC.B	$80,'?',$7F,$DF,$00,'0',$00,'0' 
	DC.B	$00,$00,$FF,$CF,$FF,$C8,$FF,$87 
	DC.B	'<',$0F,'<',$0F,$00,$00,$C3,$F0 
	DC.B	$C3,$F0,$00,$00,$E0,'?',$E0,'?' 
	DC.B	$00,$00,$1F,$C0,$1F,$C0,$00,$00 
	DC.B	$80,$00,$80,$00,$0F,$80,$7F,$E0 
	DC.B	'p`',$0F,$9F,$00,$0F,$7F,$F0
	DC.B	$7F,$FF,$BF,$CF,$F0,$00,$0F,$FF 
	DC.B	$FF,$FF,$F3,$FF,$00,$00,$80,'?' 
	DC.B	$80,'?',$7F,$DF,$00,'8',$00,'8' 
	DC.B	$00,$00,$FF,$C7,$FF,$C7,$FF,$80 
	DC.B	$80,$00,$80,$00,'<',$E0,$7F,$F0 
	DC.B	'C',$10,'<',$EF,$00,$00,$7F,$FF 
	DC.B	$7F,$FF,$BF,$F0,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$0F,$FF,$00,$00,$80,'?' 
	DC.B	$80,'?',$7F,$DF,$00,$7F,$00,$7F 
	DC.B	$00,$00,$FF,$80,$FF,$80,$FF,$00 
	DC.B	$7F,'p',$FF,$F8,$80,$88,$7F,'w' 
	DC.B	$00,$00,$7F,$FF,$7F,$FF,$BF,$FF 
	DC.B	$00,$00,$FF,$FF,$FF,$FF,$FF,$FF 
	DC.B	$00,$00,$C0,$1F,$C0,$1F,$BF,$EF 
	DC.B	$00,$7F,$00,$7F,$00,$00,$FF,$80 
	DC.B	$FF,$80,$FF,$00,$7F,$B0,$FF,$F8 
	DC.B	$80,'H',$7F,$B7,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$7F,$FF,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$FF,$FF,$00,$00,$C0,$1F 
	DC.B	$C0,$1F,$BF,$EF,$00,$FF,$00,$FF 
	DC.B	$00,$00,$FF,$00,$FF,$00,$FE,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$FF,$B8,$FF,$FC 
	DC.B	$00,'D',$FF,$BB,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,'|',$01,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$FF,$FF,$00,$00,$C0,$1F 
	DC.B	$C0,$1F,$BF,$EF,$01,$FF,$01,$FF 
	DC.B	$00,$00,$FE,$00,$FE,$00,$FC,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$FF,$B8,$FF,$FC 
	DC.B	$00,'D',$FF,$BB,$00,$00,$FC,$01 
	DC.B	$FC,$01,$03,$FE,$00,$00,$FF,$FF 
	DC.B	$FF,$FF,$01,$FF,$00,$00,$C0,$FF 
	DC.B	$C0,$FF,$BF,$07,$03,$FF,$03,$FF 
	DC.B	$00,$00,$FC,$00,$FC,$00,$F0,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$FF,$B8,$FF,$FC 
	DC.B	$00,'D',$FF,$BB,$00,$00,$80,$00 
	DC.B	$80,$00,$7F,$FF,$00,$00,$01,$FF 
	DC.B	$01,$FF,$FE,$1F,$00,$F0,$C3,$FF 
	DC.B	$C3,$0F,$BC,$F1,$0F,$FF,$0F,$FF 
	DC.B	$00,$00,$F0,$00,$F0,$00,$C0,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$FF,$B8,$FF,$FC 
	DC.B	$00,'D',$FF,$BB,$00,$00,$80,$00 
	DC.B	$80,$00,$7F,$FF,$00,$00,$00,$1F 
	DC.B	$00,$1F,$FF,$E3,$03,$FC,$C7,$FF 
	DC.B	$C4,$03,$BB,$FC,'?',$FF,'?',$FF 
	DC.B	$00,$00,$C0,$00,$C0,$00,$00,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$FF,$B8,$FF,$FD 
	DC.B	$00,'E',$FF,$BA,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$00,$00,$03 
	DC.B	$00,$03,$FF,$FC,$07,'>',$CF,$FF 
	DC.B	$C8,$C1,$B7,'>',$7F,$B0,$FF,$F9 
	DC.B	$80,'I',$7F,$B6,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$06,$FE,$CF,$FF 
	DC.B	$C9,$01,'6',$FE,$7F,'p',$FF,$F9 
	DC.B	$80,$89,$7F,'v',$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$0D,$FF,'_',$FF 
	DC.B	'R',$00,$AD,$FF,$7F,$FF,$7F,$FF 
	DC.B	$00,$00,$80,$00,$80,$00,$00,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,'<',$E0,$7F,$F2 
	DC.B	'C',$12,$BC,$ED,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$0D,$FF,'_',$FF 
	DC.B	'R',$00,$AD,$FF,$7F,$FF,$7F,$FF 
	DC.B	$00,$00,$80,$00,$80,$00,$00,$00 
	DC.B	$FF,$FE,$FF,$FE,$00,$00,$00,$01 
	DC.B	$00,$01,$00,$00,$0F,$80,'?',$E2 
	DC.B	'0b',$CF,$9D,$00,$00,$00,$00
	DC.B	$00,$00,$FF,$FF,$00,$00,$00,$00 
	DC.B	$00,$00,$FF,$FF,$0D,$FF,'_',$FF 
	DC.B	'R',$00,$AD,$FF,$7F,$FF,$7F,$FF 
	DC.B	$00,$00,$80,$00,$80,$00,$00,$00 
	DC.B	$00,$00,$8F,$82,$8F,$82,'p}'
	DCB.W	3,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$0D,$FF,'_',$FF,'R',$00 
	DC.B	$AD,$FF,$7F,$FF,$7F,$FF,$00,$00 
	DC.B	$80,$00,$80,$00,$00,$00,$00,$00 
	DC.B	$80,$04,$80,$04,$7F,$FB,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$06,$FE,'/',$FF,')',$01 
	DC.B	$D6,$FE,$00,$00,$80,$04,$80,$04 
	DC.B	$7F,$FB,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$07,'>/',$FF,'(',$C1
	DC.B	$D7,'>',$FF,$FE,$FF,$FE,$00,$00 
	DC.B	$00,$01,$00,$01,$00,$00,$00,$00 
	DC.B	'p',$08,'p',$08,$8F,$F7,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$03,$FC 
	DC.B	$27,$FE,'$',$02,$DB,$FC,$FF,$FE 
	DC.B	$FF,$FE,$00,$00,$00,$01,$00,$01 
	DCB.W	2,0 
	DC.B	$0E,$10,$0E,$10,$F1,$EF,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$00,$F0 
	DC.B	'#',$FC,'#',$0C,$DC,$F0,$FF,$FE 
	DC.B	$FF,$FE,$00,$00,$00,$01,$00,$01 
	DCB.W	2,0 
	DC.B	$01,$E0,$01,$E0,$FE,$1F,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$0F,$00,$0F,$00,$00 
	DC.B	' ',$F0,' ',$F0,$DF,$00,$FF,$F0 
	DC.B	$FF,$F0,$00,$00,$00,$0F,$00,$0F 
	DCB.W	4,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$7F,$00,$7F,$00,$00 
	DC.B	$18,$80,$18,$80,$E7,$00,$FE,$00 
	DC.B	$FE,$00,$00,$00,$01,$F1,$01,$F1 
	DC.B	$00,$0E,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'?',$00,'?',$00,$00 
	DC.B	$07,'@',$07,'@',$F8,$80,$F0,$00 
	DC.B	$F0,$00,$00,$00,$0E,$01,$0E,$01 
	DC.B	$01,$FE,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'?',$00,'?',$00,$00 
	DC.B	$00,'@',$00,'@',$FF,$80,$F8,$07 
	DC.B	$F8,$07,$00,$00,$07,$F8,$07,$F8 
	DC.B	$00,$00,$C0,$00,$C0,$00,$00,$00 
	DC.B	'0',$00,'0',$00,$0F,$FF,$00,$00 
	DC.B	$80,$00,$80,$00,$7F,$FF,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'?',$00,'?',$00,$00 
	DC.B	$00,'@',$00,'@',$FF,$80,$C0,$00 
	DC.B	$C0,$00,$00,$00,'?',$FF,'?',$FF 
	DC.B	$07,$F8,$7F,$FF,$7F,$FF,$00,$00 
	DC.B	$80,$00,$80,$00,$00,$00,$80,$00 
	DC.B	$80,$00,$00,$00,'@',$00,'@',$00 
	DC.B	'?',$FF,$00,$00,'@',$00,'@',$00 
	DC.B	$BF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1F,$00,$1F,$00,$00 
	DC.B	$00,' ',$00,' ',$FF,$C0,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,'?',$FF,$0F,$FF 
	DC.B	$0F,$FF,$00,$00,$F0,$00,$F0,$00 
	DC.B	$80,$00,$00,$00,$80,$00,$80,$00 
	DC.B	$7F,$FF,$00,$00,'0',$00,'0',$00 
	DC.B	$CF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1F,$00,$1F,$00,$00 
	DC.B	$00,' ',$00,' ',$FF,$C0,$FF,$FE 
	DC.B	$FF,$FE,$00,$00,$00,$01,$00,$01 
	DCB.W	2,0 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$03,$FF 
	DC.B	$03,$FF,$00,$00,$FC,$00,$FC,$00 
	DC.B	$F0,$00,$FF,$FE,$FF,$FE,$00,$00 
	DC.B	$00,$01,$00,$01,$00,$00,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$0E,$00,$0E,$00 
	DC.B	$F1,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1F,$00,$1F,$00,$00 
	DC.B	$00,' ',$00,' ',$FF,$C0,$FF,$FC 
	DC.B	$FF,$FC,$00,$00,$00,$03,$00,$03 
	DC.B	$00,$01,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FE,$00,$00,$FF,$00,$FF,$00,$00 
	DC.B	$FF,$00,$FF,$00,'|',$00,$FF,$FC 
	DC.B	$FF,$FC,$00,$00,$00,$02,$00,$02 
	DC.B	$00,$01,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$07,$00,$07,$00,$00 
	DC.B	$00,$18,$00,$18,$FF,$E0,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$07,$00,$07 
	DC.B	$00,$03,$01,$FF,$FF,$FF,$FE,$00 
	DC.B	$F1,$FF,$00,$7F,$00,$7F,$80,$00 
	DC.B	$FF,$80,$7F,$80,$8F,$00,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$04,$00,$04 
	DC.B	$00,$03,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$07,$00,$07 
	DC.B	$FF,$F8,$FF,$F0,$FF,$F0,$00,$00 
	DC.B	$00,$0F,$00,$0F,$00,$07,$0F,$FF 
	DC.B	$FF,$FF,$F0,$00,$CF,$FF,$00,'?' 
	DC.B	$00,'?',$F0,$00,$FF,$C0,$0F,$C0 
	DC.B	$F3,$80,$FF,$F8,$FF,$F8,$00,$00 
	DC.B	$00,$04,$00,$04,$00,$03,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,'?',$E0,'?',$E0,$00,$00 
	DC.B	$C0,$1F,$C0,$1F,$00,$0F,'?',$E1 
	DC.B	$FF,$FF,$C0,$1E,$BF,$E1,$00,$1F 
	DC.B	$00,$1F,$FC,$00,$FF,$E0,$03,$E0 
	DC.B	$FC,$C0,$FF,$F0,$FF,$F0,$00,$00 
	DC.B	$00,$08,$00,$08,$00,$07,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$1F,$C0,$1F,$C0,$00,$00 
	DC.B	' ? ?',$C0,$1F,$7F,$1E
	DC.B	$FF,$FF,$80,$E1,$7F,$1E,$00,'?' 
	DC.B	$00,'?',$1F,$00,$FF,$C0,$E0,$C0 
	DC.B	$1F,$00,$FF,$F0,$FF,$F0,$00,$00 
	DC.B	$00,$08,$00,$08,$00,$07,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$0F,$C0,$0F,$C0,$00,$00 
	DC.B	$10,'?',$10,'?',$E0,$1E,$FC,$FF 
	DC.B	$FF,$FF,$03,$00,$FC,$FF,$00,$1F 
	DC.B	$00,$1F,$E3,$C0,$FF,$E0,$1C,' ' 
	DC.B	$E3,$C0,$FF,$F0,$FF,$F0,$00,$00 
	DC.B	$00,$08,$00,$08,$00,$07,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$07,$80,$07,$80,$00,$01 
	DC.B	$08,$7F,$08,'~',$F0,'=',$F3,$FF 
	DC.B	$FF,$FF,$0C,$00,$F3,$FF,$00,$0F 
	DC.B	$00,$0F,$FC,$E0,$FF,$F0,$03,$10 
	DC.B	$FC,$E0,$FF,$E0,$FF,$E0,$00,$00 
	DC.B	$00,$10,$00,$10,$00,$0F,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$07,$80,$07,$80,$00,$03 
	DC.B	$08,$7F,$08,'|',$F0,';',$EF,$FF 
	DC.B	$FF,$FF,$10,$00,$EF,$FF,$00,$07 
	DC.B	$00,$07,$FF,'p',$FF,$F8,$00,$88 
	DC.B	$FF,'p',$FF,$E0,$FF,$E0,$00,$00 
	DC.B	$00,$10,$00,$10,$00,$0F,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$03,$00,$03,$00,$00,$03 
	DC.B	$04,$FF,$04,$FC,$F8,'{',$DF,$FF 
	DC.B	$FF,$FF,' ',$00,$DF,$FF,$00,$07 
	DC.B	$00,$07,$FF,$B0,$FF,$F8,$00,'H' 
	DC.B	$FF,$B0,$FF,$E0,$FF,$E0,$00,$00 
	DC.B	$00,$10,$00,$10,$00,$0F,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$01,$00,$01,$00,$00,$07 
	DC.B	$02,$FF,$02,$F8,$FC,'w',$BF,$FF 
	DC.B	$FF,$FF,'@',$00,$BF,$FF,$00,$03 
	DC.B	$00,$03,$FF,$D8,$FF,$FC,$00,'$' 
	DC.B	$FF,$D8,$FF,$E0,$FF,$E0,$00,$00 
	DC.B	$00,$10,$00,$10,$00,$0F,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$07,$01,$FF,$01,$F8 
	DC.B	$FE,$F7,$7F,$FF,$FF,$FF,$80,$00 
	DC.B	$7F,$FF,$00,$03,$00,$03,$FF,$D8 
	DC.B	$FF,$FC,$00,'$',$FF,$D8,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$10,$00,$10 
	DC.B	$00,$0F,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$0E,$01,$FF,$01,$F1 
	DC.B	$FE,$EE,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$10,$00,$10 
	DC.B	$00,$0F,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$0E,$01,$FF,$01,$F1 
	DC.B	$FE,$EE,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$10,$00,$10 
	DC.B	$00,$0F,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1D,$03,$FF,$03,$E2 
	DC.B	$FD,$DD,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$F0 
	DC.B	$FF,$F0,$00,$00,$00,$08,$00,$08 
	DC.B	$00,$07,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,'x',$00,'x' 
	DC.B	$FF,$87,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1D,$03,$FF,$03,$E2 
	DC.B	$FD,$DD,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$F0 
	DC.B	$FF,$F0,$00,$00,$00,$08,$00,$08 
	DC.B	$00,$07,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'x',$00,'x',$00,$00 
	DC.B	$01,$87,$01,$87,$FE,$00,$00,$00 
	DC.B	$80,$00,$80,$00,$7F,$FF,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$1B,$03,$FF,$03,$E4 
	DC.B	$FD,$DB,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$E0,'p' 
	DC.B	$E0,'p',$00,$00,$1F,$88,$1F,$88 
	DC.B	$00,$07,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$01,$FF,$01,$FF,$00,$00 
	DC.B	$02,$00,$02,$00,$FC,$00,$80,$00 
	DC.B	$80,$00,$00,$00,'x',$00,'x',$00 
	DC.B	$07,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,';',$03,$FF,$03,$C4 
	DC.B	$FD,$BB,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$00,$00 
	DC.B	$FF,$FC,$FF,$FC,$1F,$83,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$01,$FF,$01,$FF,$00,$00 
	DC.B	$02,$00,$02,$00,$FC,$00,$F8,$00 
	DC.B	$F8,$00,$00,$00,$07,$80,$07,$80 
	DC.B	$00,$7F,$00,$00,$00,'8',$00,'8' 
	DC.B	$FF,$C7,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,';',$07,$FF,$07,$C4 
	DC.B	$FB,$BB,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$FC 
	DC.B	$FF,$FC,$00,$00,$00,$03,$00,$03 
	DCB.W	2,0 
	DC.B	$FF,$FE,$FF,$FE,$FF,$F1,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$03,$FF,$03,$FF,$00,$00 
	DC.B	$04,$00,$04,$00,$F8,$00,$FF,$80 
	DC.B	$FF,$80,$00,$00,$00,'x',$00,'x' 
	DC.B	$00,$07,$00,$00,$07,$C0,$07,$C0 
	DC.B	$F8,'?',$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'7',$07,$FF,$07,$C8 
	DC.B	$FB,$B7,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$07,$00,$07 
	DC.B	$00,$03,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FE,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$03,$FF,$03,$FF,$00,$00 
	DC.B	$04,$00,$04,$00,$F8,$00,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$07,$00,$07 
	DCB.W	2,0 
	DC.B	$F8,$00,$F8,$00,$07,$FF,$00,$00 
	DCB.W	2,0 
	DC.B	$FF,$FF,$00,'7',$07,$FF,$07,$C8 
	DC.B	$FB,$B7,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$F0 
	DC.B	$FF,$F0,$00,$00,$00,$0F,$00,$0F 
	DC.B	$00,$07,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$C0,$00,$C0,$00 
	DC.B	'?',$FF,$03,$FF,$03,$FF,$00,$00 
	DC.B	$04,$00,$04,$00,$F8,$00,$F8,$00 
	DC.B	$F8,$00,$00,$00,$07,$00,$07,$00 
	DC.B	$00,$FF,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'7',$07,$FF,$07,$C8 
	DC.B	$FB,$B7,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$1F,$00,$1F 
	DC.B	$00,$0F,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$F8,$00,$F8,$00 
	DC.B	$87,$FF,$07,$FF,$07,$FF,$00,$00 
	DC.B	$08,$00,$08,$00,$F0,$00,$FF,$00 
	DC.B	$FF,$00,$00,$00,$00,$E0,$00,$E0 
	DC.B	$00,$1F,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'7',$0F,$FF,$0F,$C8 
	DC.B	$F7,$B7,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$C0 
	DC.B	$FF,$C0,$00,$00,$00,'?',$00,'?' 
	DC.B	$00,$1F,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$00,$FF,$00 
	DC.B	$C0,$FF,$01,$FF,$01,$FF,$00,$00 
	DC.B	'~',$00,'~',$00,$88,$00,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$18,$00,$18 
	DC.B	$00,$07,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'w',$0F,$FF,$0F,$88 
	DC.B	$F7,'w',$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$C0 
	DC.B	$FF,$C0,$00,$00,$00,'?',$00,'?' 
	DC.B	$00,$1F,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$E3,$FF,$E3 
	DC.B	$E7,$1C,$00,$FF,$00,$FF,$00,$00 
	DC.B	$FF,$00,$FF,$00,'~',$00,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$04,$00,$04 
	DC.B	$00,$03,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'w',$0F,$FF,$0F,$88 
	DC.B	$F7,'w',$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$80 
	DC.B	$FF,$80,$00,$00,$00,$7F,$00,$7F 
	DC.B	$00,'?',$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$F9,$E3,$00,$7F,$00,$7F,$00,$00 
	DC.B	$FF,$80,$FF,$80,$FF,$00,$FF,$FC 
	DC.B	$FF,$FC,$00,$00,$00,$02,$00,$02 
	DC.B	$00,$01,$00,$00,$00,$00,$00,$00 
	DC.B	$FF,$FF,$00,'o',$1F,$FF,$1F,$90 
	DC.B	$EF,'o',$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$80 
	DC.B	$FF,$80,$00,$00,$00,$7F,$00,$7F 
	DC.B	$00,'?',$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FE,$7F,$00,'?',$00,'?',$00,$00 
	DC.B	$FF,$C0,$FF,$C0,$FF,$80,$FF,$FE 
	DC.B	$FF,$FE,$00,$00,$00,$01,$00,$01 
	DCB.W	4,0 
	DC.B	$FF,$FF,$00,'o',$1F,$FF,$1F,$90 
	DC.B	$EF,'o',$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$03,$00,$03,$FF,$F8 
	DC.B	$FF,$FC,$00,$04,$FF,$F8,$FF,$00 
	DC.B	$FF,$00,$00,$00,$00,$FF,$00,$FF 
	DC.B	$00,$7F,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$FF,$FF 
	DC.B	$FF,$BF,$00,$1F,$00,$1F,$00,$00 
	DC.B	$FF,$E0,$FF,$E0,$FF,$C0,$00,$00 
	DC.B	$80,$00,$80,$00,$7F,$FF,$00,$EF 
	DC.B	$1F,$FF,$1F,$10,$EE,$EF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$07 
	DC.B	$00,$07,$FF,$F0,$FF,$F8,$00,$08 
	DC.B	$FF,$F0,$FF,$00,$FF,$00,$00,$00 
	DC.B	$00,$FF,$00,$FF,$00,$7F,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$DF,$00,$0F 
	DC.B	$00,$0F,$00,$00,$FF,$F0,$FF,$F0 
	DC.B	$FF,$E0,$80,$00,$80,$00,$00,$00 
	DC.B	'`',$00,'`',$00,$1F,$FF,$00,$EF 
	DC.B	$1F,$FF,$1F,$10,$EE,$EF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$07 
	DC.B	$00,$07,$FF,$F0,$FF,$F8,$00,$08 
	DC.B	$FF,$F0,$FF,$80,$FF,$80,$00,$00 
	DC.B	$00,$7F,$00,$7F,$00,'?',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$0F 
	DC.B	$00,$0F,$00,$00,$FF,$F0,$FF,$F0 
	DC.B	$FF,$E0,$E0,$00,$E0,$00,$00,$00 
	DC.B	$18,$00,$18,$00,$07,$FF,$00,$EF 
	DC.B	'?',$FF,'?',$10,$DE,$EF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$07 
	DC.B	$00,$07,$FF,$F0,$FF,$F8,$00,$08 
	DC.B	$FF,$F0,$FF,$80,$FF,$80,$00,$00 
	DC.B	$00,$7F,$00,$7F,$00,'?',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$07 
	DC.B	$00,$07,$00,$00,$FF,$F8,$FF,$F8 
	DC.B	$FF,$F0,$F8,$00,$F8,$00,$00,$00 
	DC.B	$06,$00,$06,$00,$01,$FF,$01,$EF 
	DC.B	'?',$FF,'>',$10,$DD,$EF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$0F 
	DC.B	$00,$0F,$FF,$E0,$FF,$F0,$00,$10 
	DC.B	$FF,$E0,$FF,$C0,$FF,$C0,$00,$00 
	DC.B	$00,'?',$00,'?',$00,$1F,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$07 
	DC.B	$00,$07,$00,$00,$FF,$F8,$FF,$F8 
	DC.B	$FF,$F0,$FE,$00,$FE,$00,$00,$00 
	DC.B	$01,$80,$01,$80,$00,$7F,$01,$DF 
	DC.B	'?',$FF,'> ',$DD,$DF,$FF,$FF
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$0F 
	DC.B	$00,$0F,$FF,$E0,$FF,$F0,$00,$10 
	DC.B	$FF,$E0,$FF,$80,$FF,$80,$00,' ' 
	DC.B	$00,$7F,$00,'_',$00,'/',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$07 
	DC.B	$00,$07,$00,$00,$FF,$F8,$FF,$F8 
	DC.B	$FF,$F0,$FF,$80,$FF,$80,$00,$00 
	DC.B	$00,'`',$00,'`',$00,$1F,$01,$DF 
	DC.B	$7F,$FF,'~ ',$BD,$DF,$FF,$FF
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$0F 
	DC.B	$00,$0F,$FF,$E0,$FF,$F0,$00,$10 
	DC.B	$FF,$E0,$FF,$80,$FF,$80,$00,'0' 
	DC.B	$00,$7F,$00,'O',$00,'7',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$03 
	DC.B	$00,$03,$00,$08,$FF,$FC,$FF,$F4 
	DC.B	$FF,$E8,$FF,$E0,$FF,$E0,$00,$00 
	DC.B	$00,$18,$00,$18,$00,$07,$01,$C3 
	DC.B	$7F,$FF,'~<',$BD,$C3,$FF,$FF
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$1F 
	DC.B	$00,$1F,$FF,$C0,$FF,$E0,$00,' ' 
	DC.B	$FF,$C0,$FF,$80,$FF,$80,$00,'8' 
	DC.B	$00,$7F,$00,'G',$00,'9',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$03 
	DC.B	$00,$03,$00,$18,$FF,$FC,$FF,$E4 
	DC.B	$FF,$D8,$FF,$F8,$FF,$F8,$00,$00 
	DC.B	$00,$06,$00,$06,$00,$01,$01,$BC 
	DC.B	$7F,$FF,'~C',$BD,$BC,$0F,$FF
	DC.B	$FF,$FF,$F0,$00,$0F,$FF,$00,$1F 
	DC.B	$00,$1F,$FF,$C0,$FF,$E0,$00,' ' 
	DC.B	$FF,$C0,$FF,$C0,$FF,$C0,$00,$1E 
	DC.B	$00,'?',$00,'!',$00,$1E,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$7F,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$03 
	DC.B	$00,$03,$00,'8',$FF,$FC,$FF,$C4 
	DC.B	$FF,'8',$FF,$FC,$FF,$FC,$00,$00 
	DC.B	$00,$02,$00,$02,$00,$01,$01,$7F 
	DC.B	$7F,$FF,'~',$80,$BD,$7F,$F0,$FF 
	DC.B	$FF,$FF,$0F,$00,$F0,$FF,$00,'?' 
	DC.B	$00,'?',$FF,$80,$FF,$C0,$00,'@' 
	DC.B	$FF,$80,$FF,$C0,$FF,$C0,$00,$1F 
	DC.B	$00,'?',$00,' ',$00,$1F,$80,$00 
	DC.B	$FF,$FF,$7F,$FF,$9F,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$03 
	DC.B	$00,$03,$00,'x',$FF,$FC,$FF,$84 
	DC.B	$F8,'x',$FF,$F8,$FF,$F8,$00,$00 
	DC.B	$00,$04,$00,$04,$00,$03,$01,$7F 
	DC.B	$7F,$FF,'~',$80,$BD,$7F,$FF,'?' 
	DC.B	$FF,$FF,$00,$C0,$FF,'?',$00,$7F 
	DC.B	$00,$7F,$FF,$00,$FF,$80,$00,$80 
	DC.B	$FF,$00,$FF,$E0,$FF,$E0,$00,$0F 
	DC.B	$00,$1F,$00,$10,$00,$0F,$E0,$00 
	DC.B	$FF,$FF,$1F,$FF,$E3,$FF,$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$00,$07 
	DC.B	$00,$07,$03,$F0,$FF,$F8,$FC,$08 
	DC.B	$03,$F0,$FF,$F8,$FF,$F8,$00,$00 
	DC.B	$00,$04,$00,$04,$00,$03,$00,$FF 
	DC.B	$7F,$FF,$7F,$00,$BE,$FF,$FF,$CF 
	DC.B	$FF,$FF,$00,'0',$FF,$CF,$00,$FF 
	DC.B	$00,$FF,$FE,$00,$FF,$00,$01,$00 
	DC.B	$FE,$00,$FF,$F0,$FF,$F0,$00,$07 
	DC.B	$00,$0F,$00,$08,$00,$07,$FC,$00 
	DC.B	$FF,$FF,$03,$FF,$FC,'?',$00,$00 
	DC.B	$FF,$FF,$FF,$FF,$FF,$E0,$00,$07 
	DC.B	$00,$07,$FF,$F0,$FF,$F8,$00,$08 
	DC.B	$FF,$F0,$FF,$F8,$FF,$F8,$00,$00 
	DC.B	$00,$04,$00,$04,$00,$03,$00,$FF 
	DC.B	'?',$FF,'?',$00,$DE,$FF,$FF,$F7 
	DC.B	$FF,$FF,$00,$08,$FF,$F7,$01,$FF 
	DC.B	$01,$FF,$FC,$00,$FE,$00,$02,$00 
	DC.B	$FC,$00,$FF,$F8,$FF,$F8,$00,$01 
	DC.B	$00,$07,$00,$06,$00,$01,$FF,$C0 
	DC.B	$FF,$FF,$00,'?',$FF,$C1,$00,$1F 
	DC.B	$FF,$FF,$FF,$E0,$F8,$1F,$00,$0F 
	DC.B	$00,$0F,$FF,$E0,$FF,$F0,$00,$10 
	DC.B	$FF,$E0,$FF,$FC,$FF,$FC,$00,$00 
	DC.B	$00,$02,$00,$02,$00,$01,$00,$FF 
	DC.B	'?',$FF,'?',$00,$DE,$FF,$FF,$F9 
	DC.B	$FF,$FF,$00,$06,$FF,$F9,$03,$FF 
	DC.B	$03,$FF,$F8,$00,$FC,$00,$04,$00 
	DC.B	$F8,$00,$FF,$FE,$FF,$FE,$00,$00 
	DC.B	$00,$01,$00,$01,$00,$00,'?',$FE 
	DC.B	$FF,$FF,$C0,$01,'?',$FE,$07,$FF 
	DC.B	$FF,$FF,$F8,$00,$07,$FF,$00,$1F 
	DC.B	$00,$1F,$FF,$00,$FF,$E0,$00,$E0 
	DC.B	$FF,$00,$FF,$FC,$FF,$FC,$00,$00 
	DC.B	$00,$02,$00,$02,$00,$01,$00,$FF 
	DC.B	'?',$FF,'?',$00,$DE,$FF,$FF,$FE 
	DC.B	$FF,$FF,$00,$01,$FF,$FE,$03,$FF 
	DC.B	$03,$FF,'x',$00,$FC,$00,$84,$00 
	DC.B	'x',$00,$C0,$00,$C0,$00,$03,$FF 
	DC.B	'?',$FF,'<',$00,$03,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$00,$FF 
	DC.B	$00,$FF,$E0,$00,$FF,$00,$1F,$00 
	DC.B	$E0,$00,$FF,$FE,$FF,$FE,$00,$00 
	DC.B	$00,$01,$00,$01,$00,$00,$00,$FF 
	DC.B	'?',$FF,'?',$00,$DE,$FF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$07,$FF 
	DC.B	$07,$FF,$B0,$00,$F8,$00,'H',$00 
	DC.B	$B0,$00,$FC,$00,$FC,$00,$00,$1F 
	DC.B	$03,$FF,$03,$E0,$00,$1F,$FF,$F8 
	DC.B	$FF,$FF,$00,$07,$FF,$F8,$1F,$FF 
	DC.B	$1F,$FF,$00,$00,$E0,$00,$E0,$00 
	DC.B	$00,$00,$00,$7F,$BF,$FF,$BF,$80 
	DC.B	'_',$7F,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$0F,$FF,$0F,$FF,$E0,$00 
	DC.B	$F0,$00,$10,$00,$E0,$00,$FF,$E0 
	DC.B	$FF,$E0,$00,$00,$00,$1F,$00,$1F 
	DC.B	$00,$00,$00,$07,$00,$07,'~',$00 
	DC.B	$FF,$F8,$81,$F8,'~',$00,$A0,$00 
	DC.B	$A0,$00,$00,$7F,'_',$FF,'_',$80 
	DC.B	$0F,$7F,$FF,$FF,$FF,$FF,$00,$00 
	DC.B	$FF,$FF,$1F,$FF,$1F,$FF,$C0,$00 
	DC.B	$E0,$00,' ',$00,$C0,$00,$81,$FF 
	DC.B	$81,$FF,$00,$00,'~',$00,'~',$00 
	DC.B	$00,$00,$E0,$00,$E0,$00,$00,$7F 
	DC.B	$1F,$FF,$1F,$80,$0F,$7F,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$1F,$FF 
	DC.B	$1F,$FF,$C0,$00,$E0,$00,' ',$00 
	DC.B	$C0,$00,$F0,$00,$F0,$00,$00,$7F 
	DC.B	$0F,$FF,$0F,$80,$07,$7F,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,'?',$FF 
	DC.B	'?',$FF,$80,$00,$C0,$00,'@',$00 
	DC.B	$80,$00,$F8,$00,$F8,$00,$00,'?' 
	DC.B	$07,$FF,$07,$C0,$03,$BF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,'?',$FF 
	DC.B	'?',$FF,$80,$00,$C0,$00,'@',$00 
	DC.B	$80,$00,$FC,$00,$FC,$00,$00,'?' 
	DC.B	$03,$FF,$03,$C0,$01,$BF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$7F,$FF 
	DC.B	$7F,$FF,$00,$00,$80,$00,$80,$00 
	DC.B	$00,$00,$FE,$00,$FE,$00,$00,'?' 
	DC.B	$01,$FF,$01,$C0,$00,$BF,$FF,$FF 
	DC.B	$FF,$FF,$00,$00,$FF,$FF,$7F,$FF 
	DC.B	$7F,$FF,$00,$00,$80,$00,$80,$00 
	DC.B	$00,$00,$FF,$00,$FF,$00,$00,$1F 
	DC.B	$00,$FF,$00,$E0,$00,'_',$FF,$FE 
	DC.B	$FF,$FF,$00,$01,$FF,$FE,$FF,$80 
	DC.B	$FF,$80,$00,$1F,$00,$7F,$00,'`' 
	DC.B	$00,$1F,$00,$01,$00,$01,$FF,$FC 
	DC.B	$FF,$FE,$00,$02,$FF,$FC,$FF,$E0 
	DC.B	$FF,$E0,$00,$07,$00,$1F,$00,$18 
	DC.B	$00,$07,$00,$03,$00,$03,$FF,$F0 
	DC.B	$FF,$FC,$00,$0C,$FF,$F0,$FF,$F8 
	DC.B	$FF,$F8,$00,$00,$00,$07,$00,$07 
	DC.B	$00,$00,$00,$0F,$00,$0F,$FF,$00 
	DC.B	$FF,$F0,$00,$F0,$FF,$00,$00,$FF 
	DC.B	$00,$FF,$00,$00,$FF,$00,$FF,$00 
	DC.B	$00,$00 

L009D	DC.B	'C',$E9,$00,'("',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$90,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$88,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,$88 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$88,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,$88 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$88,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$80,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'`' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'`"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'`' 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$D8,'"',$D8
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'`"',$D8,'"',$D8,'"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'`' 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'P"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'X"',$D8,'"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'P"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'C',$E9 
	DC.B	$00,'X"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'`"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'`"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'h"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'x"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'x"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'C',$E9,$00,$80 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,$80,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'p"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'x"',$D8,'"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,$80,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'x' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'x"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'PI"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'h"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'PI"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'`"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'`"',$D8,'"',$D8,'"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'X"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'X"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'X' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$D8
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'P"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'PI"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'P"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'PI"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'PI"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'P' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'PI"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'P"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'PI'
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'P"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$10,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'P"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$10,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,'X"',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,$10,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,'X"',$11,$C2,$98,$82,$98
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$18,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,'X"',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,' "',$11,$C2,$98
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$D8 
	DC.B	'"',$D8,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'C',$E9,$00,'`' 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,' "',$11
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,$88,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$88,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,$88,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'"',$11,$C2,$98,$82,$98,'"',$C1 
	DC.B	'"',$D8,'C',$E9,$00,$88,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'"',$D8,'"',$D8,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'C',$E9 
	DC.B	$00,$88,'"',$11,$C2,$98,$82,$98 
	DC.B	'"',$C1,'"',$D8,'"',$D8,'"',$D8 
	DC.B	'C',$E9,$00,$90,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$90,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$90,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'"',$11 
	DC.B	$C2,$98,$82,$98,'"',$C1,'"',$D8 
	DC.B	'C',$E9,$00,$98,'"',$11,$C2,$98 
	DC.B	$82,$98,'"',$C1,'"',$D8,'Nu'
	even

font	dcb.b	34*4,0
	incbin	font.dat
	even

font_offsets
;          !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /
 dc.b	0,46,48,00,00,00,00,48,41,42,44,00,27,43,28,45

;        0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @
 dc.b	40,31,32,33,34,35,36,37,38,39,30,29,00,00,00,47,00

;        A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q
 dc.b	01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17

;        R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c
 dc.b	18,19,20,21,22,23,24,25,26,41,00,42,00,00,48,01,02,03

;        d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u
 dc.b	04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21

;        v  w  x  y  z  {
 dc.b	22,23,24,25,26,49
	even
char_off	dc.w	0 


scroll_pointer	dc.l	scroll_text 
scroll_text
	INCBIN	TEXT.TXT
	DC.W	-1,-1

	even
L00A2	DC.B	$00,$A0,$00,'0',$00,$B0,$00,'@' 
	DC.B	$00,$C0,$00,'P',$00,$D0,$00,'`' 
	DC.B	$00,$E0,$00,'p',$00,$F0,$00,$A0 
	DC.B	$00,$B0,$00,$C0,$00,$D0,$00,$E0 
	DC.B	$00,$F0,$00,$F0,$00,$E0,$00,$D0 
	DC.B	$00,$C0,$00,$B0,$00,$A0,$00,$F0 
	DC.B	$00,'p',$00,$E0,$00,'`',$00,$D0 
	DC.B	$00,'P',$00,$C0,$00,'@',$00,$B0 
	DC.B	$00,'0',$00,$A0 
L00A3	DC.B	$03,'E',$04,'V',$05,'g',$04,'V' 
	DC.B	$03,'E',$02,'4',$03,'E',$04,'V' 
	DC.B	$05,'g',$04,'V',$03,'E',$02,'4' 
	DC.B	$03,'E',$04,'V',$05,'g',$04,'V' 
	DC.B	$03,'E',$02,'4',$03,'E',$04,'V' 
	DC.B	$05,'g',$04,'V',$03,'E',$02,'4' 
	DC.B	$03,'E',$04,'V',$05,'g',$04,'V' 
	DC.B	$03,'E',$02,'4' 

straighten_out_gfx
	DC.B	$FC,$00,$00,$00,$00,'<',$00,$00 
	DC.B	$FC,$00,$00,$00,$00,'<',$00,$00 
	DC.B	$03,$C0,$00,$00,$FC,$00,$00,$00 
	DC.B	$00,'<',$00,$00,$03,$C0,$00,$00 
	DC.B	$FC,$00,$00,$00,$00,'<',$00,$00 
	DC.B	$FC,$01,$00,$00,$FF,$FC,$00,$00 
	DC.B	$FF,$FC,$00,$00,$FF,$FC,$00,$00 
	DC.B	$F3,$FC,$00,$00,$03,$C0,$00,$00 
	DC.B	$F3,$FF,$00,$00,$F9,$FC,$00,$00 
	DC.B	$01,$E0,$00,$00,'<',$00,$00,$00 
	DC.B	$7F,$FC,$00,$00,$F0,'<',$00,$00 
	DC.B	$FF,$FF,$00,$00,$FC,$01,$00,$00 
	DC.B	$FF,$FC,$00,$00,$FF,$FC,$00,$00 
	DC.B	$FF,$FC,$00,$00,$F3,$FC,$00,$00 
	DC.B	$03,$C0,$00,$00,$F3,$FF,$00,$00 
	DC.B	$F9,$FC,$00,$00,$01,$F0,$00,$00 
	DC.B	'<',$00,$00,$00,$7F,$FC,$00,$00 
	DC.B	$F0,'<',$00,$00,$FF,$FF,$00,$00 
	DC.B	$FC,$01,$00,$00,$FF,$FC,$00,$00 
	DC.B	$FF,$FC,$00,$00,$FF,$FC,$00,$00 
	DC.B	$F3,$FC,$00,$00,$03,$C0,$00,$00 
	DC.B	$F3,$FF,$00,$00,$F9,$FC,$00,$00 
	DC.B	$01,$F8,$00,$00,'<',$00,$00,$00 
	DC.B	$7F,$FC,$00,$00,$F0,'<',$00,$00 
	DC.B	$FF,$FF,$00,$00,$FC,$01,$00,$00 
	DC.B	$FF,$FC,$00,$00,$FF,$FC,$00,$00 
	DC.B	$FF,$FC,$00,$00,$F3,$FC,$00,$00 
	DC.B	$03,$C0,$00,$00,$F3,$FF,$00,$00 
	DC.B	$F9,$FC,$00,$00,$01,$FC,$00,$00 
	DC.B	'<',$00,$00,$00,$7F,$FC,$00,$00 
	DC.B	$F0,'<',$00,$00,$FF,$FF,$00,$00 
	DC.B	$F0,$01,$00,$00,$E7,$80,$00,$00 
	DC.B	$F0,'<',$00,$00,$F0,'<',$00,$00 
	DC.B	$03,$C0,$00,$00,$03,$C0,$00,$00 
	DC.B	$F3,$CF,$00,$00,$01,$E0,$00,$00 
	DC.B	$01,$FE,$00,$00,'<',$00,$00,$00 
	DC.B	'x<',$00,$00,$F0,'<',$00,$00
	DC.B	$F3,$C0,$00,$00,$A0,$00,'P',$01 
	DC.B	$A2,$80,'E',$00,$00,'(',$00,$14 
	DC.B	$A0,'(P',$14,$A2,$80,'Q@' 
	DC.B	$02,$80,$01,'@',$A2,$8A,'QE'
	DC.B	$00,$A0,$01,'@',$00,$AA,$01,'U' 
	DC.B	'(',$00,$14,$00,'P',$14,'(('
	DC.B	'P',$14,$A0,'(Q@',$A2,$80 
	DC.B	'UU',$AA,$A8,'E',$00,$A2,$80
	DC.B	'UT',$AA,$A8,'U',$14,$AA,$A8
	DC.B	'QA',$A2,$82,'QU',$A2,$AA 
	DC.B	'QE',$A2,$8A,$01,'U',$00,$AA
	DC.B	$01,'U',$80,$AA,$14,$00,$A8,$00 
	DC.B	'((P',$14,$A0,'(P',$14
	DC.B	$A2,$80,'Q@',$AA,$A8,'UT' 
	DC.B	$02,$80,$05,$00,$AA,$A8,'UT'
	DC.B	$AA,$A8,'U',$14,$A2,$82,'QA'
	DC.B	$A2,$AA,'QU',$A0,$0A,'P',$05
	DC.B	$00,$AA,$01,'U',$80,$AA,$01,'E' 
	DC.B	$A8,$00,'T',$00,'P',$14,'(('
	DC.B	'P',$14,$A0,'(',$01,'@',$02,$80 
	DC.B	$00,$00,$FF,$FC,$00,$00,$07,$80 
	DC.B	$00,$00,$FF,$FC,$00,$00,$FF,$BC 
	DC.B	$00,$00,$F3,$C3,$00,$00,$F3,$FF 
	DC.B	$00,$00,$F0,$0F,$00,$00,$01,$FF 
	DC.B	$00,$00,$81,$E7,$00,$00,$FC,$00 
	DC.B	$00,$00,'x<',$00,$00,$F0,'<'
	DC.B	$00,$00,$03,$C0,$00,$00,$FF,$FC 
	DC.B	$00,$00,$07,$80,$00,$00,$FF,$FC 
	DC.B	$00,$00,$FF,$BC,$00,$00,$F3,$C3 
	DC.B	$00,$00,$F3,$FF,$00,$00,$F0,$0F 
	DC.B	$00,$00,$01,$FF,$00,$00,$81,$E3 
	DC.B	$00,$00,$FC,$00,$00,$00,'x<'
	DC.B	$00,$00,$F0,'<',$00,$00,$03,$C0 
	DC.B	$00,$00,$00,'<',$00,$00,$07,$80 
	DC.B	$00,$00,$F1,$E0,$00,$00,$F0,'<' 
	DC.B	$00,$00,$F3,$C0,$00,$00,$F3,$C0 
	DC.B	$00,$00,$F0,$0F,$00,$00,$01,$E0 
	DC.B	$00,$00,$01,$E1,$00,$00,$FC,$00 
	DC.B	$00,$00,'x<',$00,$00,$F0,'<'
	DC.B	$00,$00,$03,$C0,$00,'(',$00,$14 
	DC.B	$02,$80,$05,$00,$A0,$A0,'Q@'
	DC.B	$A0,'(P',$14,$A2,$80,'Q@' 
	DC.B	$A2,$80,'Q@',$A0,$0A,'P',$05
	DC.B	$00,$A0,$01,'@(',$A0,'Q@' 
	DC.B	$A8,$00,'T',$00,'P',$14,'(('
	DC.B	'P',$14,$A0,'(',$01,'@',$02,$80 
	DC.B	'UT',$AA,$A8,$05,$00,$02,$80
	DC.B	'QT',$A0,$A8,'P',$14,$A0,'('
	DC.B	'QU',$A2,$AA,'Q@',$A2,$80 
	DC.B	'P',$05,$A0,$0A,$01,'U',$00,$AA 
	DC.B	'Q@',$A8,$A0,'T',$00,'(',$00
	DC.B	'*',$A8,'U',$14,$AA,$A8,'UT'
	DC.B	$02,$80,$01,'@',$AA,$A8,'UT'
	DC.B	$02,$80,$05,$00,$A0,$A8,'QT'
	DC.B	$A0,'(P',$14,$A2,$AA,'QU' 
	DC.B	$A2,$80,'Q@',$A0,$0A,'P',$05
	DC.B	$00,$AA,$01,'U',$A8,$A0,'Q@'
	DC.B	'(',$00,$14,$00,'U',$14,'*',$A8 
	DC.B	'UT',$AA,$A8,$01,'@',$02,$80
	DC.B	$FF,$FC,$00,$00,$07,$80,$00,$00 
	DC.B	$F1,$FC,$00,$00,$F0,'<',$00,$00 
	DC.B	$F3,$FF,$00,$00,$F3,$C0,$00,$00 
	DC.B	$F0,$0F,$00,$00,$01,$FF,$00,$00 
	DC.B	$F9,$E0,$00,$00,$1C,$00,$00,$00 
	DC.B	$7F,$BC,$00,$00,$FF,$FC,$00,$00 
	DC.B	$03,$C0,$00,$00,$FF,$FC,$00,$00 
	DC.B	$07,$80,$00,$00,$F1,$FC,$00,$00 
	DC.B	$F0,'<',$00,$00,$F3,$FF,$00,$00 
	DC.B	$F3,$C0,$00,$00,$F0,$0F,$00,$00 
	DC.B	$01,$FF,$00,$00,$F9,$E0,$00,$00 
	DC.B	$0C,$00,$00,$00,$7F,$BC,$00,$00 
	DC.B	$FF,$FC,$00,$00,$03,$C0,$00,$00 
	DC.B	$F0,$00,$00,$00,$F0,$00,$00,$00 
	DC.B	$F0,$00,$00,$00,$F0,$00,$00,$00 
	DC.B	$01,$E0,$00,$00,$04,$00,$00,$00 
	DC.B	$03,$C0,$00,$00,$A0,$00,'P',$00 
	DC.B	$A0,$00,'P',$00,$A0,$00,'P',$00 
	DC.B	$A0,$00,'P',$00,$00,$A0,$01,'@' 
	DC.B	$01,'@',$02,$80,'P',$00,$A0,$00 
	DC.B	'P',$00,$A0,$00,'P',$00,$A0,$00 
	DC.B	'P',$00,$A0,$00,$01,'@',$00,$A0 
	DC.B	$02,$80,$01,'@',$00,$00,$F0,$00 
	DC.B	$00,$00,$F0,$00,$00,$00,$F0,$00 
	DC.B	$00,$00,$F0,$00,$00,$00,$01,$E0 
	DC.B	$00,$00,$03,$C0 

L00A5	MOVE.L	(A0)+,$48(A1)
	MOVE.L	(A0)+,$58(A1)
	MOVE.L	(A0)+,$E8(A1)
	MOVE.L	(A0)+,$F8(A1)
	MOVE.L	(A0)+,$168(A1)
	MOVE.L	(A0)+,$188(A1)
	MOVE.L	(A0)+,$198(A1)
	MOVE.L	(A0)+,$208(A1)
	MOVE.L	(A0)+,$228(A1)
	MOVE.L	(A0)+,$238(A1)
	MOVE.L	(A0)+,$280(A1)
	MOVE.L	(A0)+,$288(A1)
	MOVE.L	(A0)+,$290(A1)
	MOVE.L	(A0)+,$298(A1)
	MOVE.L	(A0)+,$2A0(A1)
	MOVE.L	(A0)+,$2A8(A1)
	MOVE.L	(A0)+,$2B0(A1)
	MOVE.L	(A0)+,$2B8(A1)
	MOVE.L	(A0)+,$2C0(A1)
	MOVE.L	(A0)+,$2C8(A1)
	MOVE.L	(A0)+,$2D0(A1)
	MOVE.L	(A0)+,$2D8(A1)
	MOVE.L	(A0)+,$2E0(A1)
	MOVE.L	(A0)+,$320(A1)
	MOVE.L	(A0)+,$328(A1)
	MOVE.L	(A0)+,$330(A1)
	MOVE.L	(A0)+,$338(A1)
	MOVE.L	(A0)+,$340(A1)
	MOVE.L	(A0)+,$348(A1)
	MOVE.L	(A0)+,$350(A1)
	MOVE.L	(A0)+,$358(A1)
	MOVE.L	(A0)+,$360(A1)
	MOVE.L	(A0)+,$368(A1)
	MOVE.L	(A0)+,$370(A1)
	MOVE.L	(A0)+,$378(A1)
	MOVE.L	(A0)+,$380(A1)
	MOVE.L	(A0)+,$3C0(A1)
	MOVE.L	(A0)+,$3C8(A1)
	MOVE.L	(A0)+,$3D0(A1)
	MOVE.L	(A0)+,$3D8(A1)
	MOVE.L	(A0)+,$3E0(A1)
	MOVE.L	(A0)+,$3E8(A1)
	MOVE.L	(A0)+,$3F0(A1)
	MOVE.L	(A0)+,$3F8(A1)
	MOVE.L	(A0)+,$400(A1)
	MOVE.L	(A0)+,$408(A1)
	MOVE.L	(A0)+,$410(A1)
	MOVE.L	(A0)+,$418(A1)
	MOVE.L	(A0)+,$420(A1)
	MOVE.L	(A0)+,$460(A1)
	MOVE.L	(A0)+,$468(A1)
	MOVE.L	(A0)+,$470(A1)
	MOVE.L	(A0)+,$478(A1)
	MOVE.L	(A0)+,$480(A1)
	MOVE.L	(A0)+,$488(A1)
	MOVE.L	(A0)+,$490(A1)
	MOVE.L	(A0)+,$498(A1)
	MOVE.L	(A0)+,$4A0(A1)
	MOVE.L	(A0)+,$4A8(A1)
	MOVE.L	(A0)+,$4B0(A1)
	MOVE.L	(A0)+,$4B8(A1)
	MOVE.L	(A0)+,$4C0(A1)
	MOVE.L	(A0)+,$500(A1)
	MOVE.L	(A0)+,$508(A1)
	MOVE.L	(A0)+,$510(A1)
	MOVE.L	(A0)+,$518(A1)
	MOVE.L	(A0)+,$520(A1)
	MOVE.L	(A0)+,$528(A1)
	MOVE.L	(A0)+,$530(A1)
	MOVE.L	(A0)+,$538(A1)
	MOVE.L	(A0)+,$540(A1)
	MOVE.L	(A0)+,$548(A1)
	MOVE.L	(A0)+,$550(A1)
	MOVE.L	(A0)+,$558(A1)
	MOVE.L	(A0)+,$560(A1)
	MOVE.L	(A0)+,$5A0(A1)
	MOVE.L	(A0)+,$5A8(A1)
	MOVE.L	(A0)+,$5B0(A1)
	MOVE.L	(A0)+,$5B8(A1)
	MOVE.L	(A0)+,$5C0(A1)
	MOVE.L	(A0)+,$5C8(A1)
	MOVE.L	(A0)+,$5D0(A1)
	MOVE.L	(A0)+,$5D8(A1)
	MOVE.L	(A0)+,$5E0(A1)
	MOVE.L	(A0)+,$5E8(A1)
	MOVE.L	(A0)+,$5F0(A1)
	MOVE.L	(A0)+,$5F8(A1)
	MOVE.L	(A0)+,$600(A1)
	MOVE.L	(A0)+,$640(A1)
	MOVE.L	(A0)+,$648(A1)
	MOVE.L	(A0)+,$650(A1)
	MOVE.L	(A0)+,$658(A1)
	MOVE.L	(A0)+,$660(A1)
	MOVE.L	(A0)+,$668(A1)
	MOVE.L	(A0)+,$670(A1)
	MOVE.L	(A0)+,$678(A1)
	MOVE.L	(A0)+,$680(A1)
	MOVE.L	(A0)+,$688(A1)
	MOVE.L	(A0)+,$690(A1)
	MOVE.L	(A0)+,$698(A1)
	MOVE.L	(A0)+,$6A0(A1)
	MOVE.L	(A0)+,$6E0(A1)
	MOVE.L	(A0)+,$6E8(A1)
	MOVE.L	(A0)+,$6F0(A1)
	MOVE.L	(A0)+,$6F8(A1)
	MOVE.L	(A0)+,$700(A1)
	MOVE.L	(A0)+,$708(A1)
	MOVE.L	(A0)+,$710(A1)
	MOVE.L	(A0)+,$718(A1)
	MOVE.L	(A0)+,$720(A1)
	MOVE.L	(A0)+,$728(A1)
	MOVE.L	(A0)+,$730(A1)
	MOVE.L	(A0)+,$738(A1)
	MOVE.L	(A0)+,$740(A1)
	MOVE.L	(A0)+,$780(A1)
	MOVE.L	(A0)+,$788(A1)
	MOVE.L	(A0)+,$790(A1)
	MOVE.L	(A0)+,$798(A1)
	MOVE.L	(A0)+,$7A0(A1)
	MOVE.L	(A0)+,$7A8(A1)
	MOVE.L	(A0)+,$7B0(A1)
	MOVE.L	(A0)+,$7B8(A1)
	MOVE.L	(A0)+,$7C0(A1)
	MOVE.L	(A0)+,$7C8(A1)
	MOVE.L	(A0)+,$7D0(A1)
	MOVE.L	(A0)+,$7D8(A1)
	MOVE.L	(A0)+,$7E0(A1)
	MOVE.L	(A0)+,$820(A1)
	MOVE.L	(A0)+,$828(A1)
	MOVE.L	(A0)+,$830(A1)
	MOVE.L	(A0)+,$838(A1)
	MOVE.L	(A0)+,$840(A1)
	MOVE.L	(A0)+,$848(A1)
	MOVE.L	(A0)+,$850(A1)
	MOVE.L	(A0)+,$858(A1)
	MOVE.L	(A0)+,$860(A1)
	MOVE.L	(A0)+,$868(A1)
	MOVE.L	(A0)+,$870(A1)
	MOVE.L	(A0)+,$878(A1)
	MOVE.L	(A0)+,$880(A1)
	MOVE.L	(A0)+,$8C0(A1)
	MOVE.L	(A0)+,$8C8(A1)
	MOVE.L	(A0)+,$8D0(A1)
	MOVE.L	(A0)+,$8D8(A1)
	MOVE.L	(A0)+,$8E0(A1)
	MOVE.L	(A0)+,$8E8(A1)
	MOVE.L	(A0)+,$8F0(A1)
	MOVE.L	(A0)+,$8F8(A1)
	MOVE.L	(A0)+,$900(A1)
	MOVE.L	(A0)+,$908(A1)
	MOVE.L	(A0)+,$910(A1)
	MOVE.L	(A0)+,$918(A1)
	MOVE.L	(A0)+,$920(A1)
	MOVE.L	(A0)+,$960(A1)
	MOVE.L	(A0)+,$968(A1)
	MOVE.L	(A0)+,$970(A1)
	MOVE.L	(A0)+,$978(A1)
	MOVE.L	(A0)+,$980(A1)
	MOVE.L	(A0)+,$988(A1)
	MOVE.L	(A0)+,$990(A1)
	MOVE.L	(A0)+,$998(A1)
	MOVE.L	(A0)+,$9A0(A1)
	MOVE.L	(A0)+,$9A8(A1)
	MOVE.L	(A0)+,$9B0(A1)
	MOVE.L	(A0)+,$9B8(A1)
	MOVE.L	(A0)+,$9C0(A1)
	MOVE.L	(A0)+,$A00(A1)
	MOVE.L	(A0)+,$A08(A1)
	MOVE.L	(A0)+,$A10(A1)
	MOVE.L	(A0)+,$A18(A1)
	MOVE.L	(A0)+,$A20(A1)
	MOVE.L	(A0)+,$A28(A1)
	MOVE.L	(A0)+,$A30(A1)
	MOVE.L	(A0)+,$A38(A1)
	MOVE.L	(A0)+,$A40(A1)
	MOVE.L	(A0)+,$A48(A1)
	MOVE.L	(A0)+,$A50(A1)
	MOVE.L	(A0)+,$A58(A1)
	MOVE.L	(A0)+,$A60(A1)
	MOVE.L	(A0)+,$AA0(A1)
	MOVE.L	(A0)+,$AA8(A1)
	MOVE.L	(A0)+,$AB0(A1)
	MOVE.L	(A0)+,$AB8(A1)
	MOVE.L	(A0)+,$AC0(A1)
	MOVE.L	(A0)+,$AC8(A1)
	MOVE.L	(A0)+,$AD0(A1)
	MOVE.L	(A0)+,$AD8(A1)
	MOVE.L	(A0)+,$AE0(A1)
	MOVE.L	(A0)+,$AE8(A1)
	MOVE.L	(A0)+,$AF0(A1)
	MOVE.L	(A0)+,$AF8(A1)
	MOVE.L	(A0)+,$B00(A1)
	MOVE.L	(A0)+,$B40(A1)
	MOVE.L	(A0)+,$B48(A1)
	MOVE.L	(A0)+,$B50(A1)
	MOVE.L	(A0)+,$B58(A1)
	MOVE.L	(A0)+,$B60(A1)
	MOVE.L	(A0)+,$B68(A1)
	MOVE.L	(A0)+,$B70(A1)
	MOVE.L	(A0)+,$B78(A1)
	MOVE.L	(A0)+,$B80(A1)
	MOVE.L	(A0)+,$B88(A1)
	MOVE.L	(A0)+,$B90(A1)
	MOVE.L	(A0)+,$B98(A1)
	MOVE.L	(A0)+,$BA0(A1)
	MOVE.L	(A0)+,$BE0(A1)
	MOVE.L	(A0)+,$BE8(A1)
	MOVE.L	(A0)+,$BF0(A1)
	MOVE.L	(A0)+,$BF8(A1)
	MOVE.L	(A0)+,$C00(A1)
	MOVE.L	(A0)+,$C08(A1)
	MOVE.L	(A0)+,$C10(A1)
	MOVE.L	(A0)+,$C18(A1)
	MOVE.L	(A0)+,$C20(A1)
	MOVE.L	(A0)+,$C28(A1)
	MOVE.L	(A0)+,$C30(A1)
	MOVE.L	(A0)+,$C38(A1)
	MOVE.L	(A0)+,$C40(A1)
	MOVE.L	(A0)+,$C90(A1)
	MOVE.L	(A0)+,$C98(A1)
	MOVE.L	(A0)+,$CA0(A1)
	MOVE.L	(A0)+,$CB0(A1)
	MOVE.L	(A0)+,$CC0(A1)
	MOVE.L	(A0)+,$CC8(A1)
	MOVE.L	(A0)+,$CE0(A1)
	MOVE.L	(A0)+,$D30(A1)
	MOVE.L	(A0)+,$D38(A1)
	MOVE.L	(A0)+,$D40(A1)
	MOVE.L	(A0)+,$D50(A1)
	MOVE.L	(A0)+,$D60(A1)
	MOVE.L	(A0)+,$D80(A1)
	MOVE.L	(A0)+,$DD0(A1)
	MOVE.L	(A0)+,$DD8(A1)
	MOVE.L	(A0)+,$DE0(A1)
	MOVE.L	(A0)+,$DF0(A1)
	MOVE.L	(A0)+,$E00(A1)
	MOVE.L	(A0)+,$E20(A1)
	MOVE.L	(A0)+,$E70(A1)
	MOVE.L	(A0)+,$E78(A1)
	MOVE.L	(A0)+,$E80(A1)
	MOVE.L	(A0)+,$E90(A1)
	MOVE.L	(A0)+,$EA0(A1)
	MOVE.L	(A0)+,$EC0(A1)
	RTS

L00A6	DC.B	$1F,$C0,$00,$00,$00,$03,$00,$00 
	DC.B	$FF,$FE,$00,$00,$00,$0F,$00,$00 
	DC.B	$FF,$FF,$00,$00,$C0,$00,$00,$00 
	DC.B	$00,'?',$00,$00,$FF,$FF,$00,$00 
	DC.B	$E0,$00,$00,$00,$00,$7F,$00,$00 
	DC.B	$FF,$FF,$00,$00,$F8,$00,$00,$00 
	DC.B	$00,$00,$00,$7F,$00,$00,$FF,$FC 
	DC.B	$00,$FF,$00,$00,$FF,$FF,$00,$00 
	DC.B	$FC,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$00,$00,$FF,$FE,$01,$FF,$00,$00 
	DC.B	$FF,$FF,$00,$00,$FE,$00,$00,$00 
	DC.B	$00,$00,$00,$7F,$00,$00,$FF,$FE 
	DC.B	$03,$FF,$00,$00,$F8,$7F,$00,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$00,$00,$FF,$FE,$07,$FF,$00,$00 
	DC.B	$80,$07,$00,$00,$FF,$80,$00,$00 
	DC.B	$00,$00,$00,$7F,$00,$00,$FF,$FE 
	DC.B	$0F,$FE,$00,$00,$00,$01,$00,$00 
	DC.B	$FF,$C0,$00,$00,$00,$00,$00,$7F 
	DC.B	$00,$00,$FF,$FE,$1F,$FC,$00,$00 
	DC.B	$FF,$C0,$00,$00,$00,$00,$00,'?' 
	DC.B	$00,$00,$FF,$FE,'@',$00,'@',$00 
	DC.B	$1F,$F0,$00,$00,$7F,$E0,$00,$00 
	DC.B	$00,$00,'?',$FE,'`',$00,'`',$00 
	DC.B	'?',$F0,$00,$00,'?',$E0,$00,$00 
	DC.B	$00,$0E,$00,$0E,$00,$00,$7F,$FE 
	DC.B	$F0,$00,$F0,$00,'?',$E0,$00,$00 
	DC.B	$1F,$F0,$00,$00,$00,$1C,$00,$1C 
	DC.B	$00,$00,$FF,$FE,$F8,$00,$F8,$00 
	DC.B	$7F,$C0,$00,$00,$0F,$F0,$00,$00 
	DC.B	$00,'8',$00,'9',$00,$00,$FF,$FE 
	DC.B	$00,$01,$00,$01,$FC,$00,$FC,$00 
	DC.B	$7F,$80,$00,$00,$0F,$F8,$00,$00 
	DC.B	$00,'p',$00,'s',$00,$00,$FF,$FE 
	DC.B	$00,$01,$00,$01,$FC,$00,$FC,$00 
	DC.B	$7F,$80,$00,$00,$06,$00,$00,$00 
	DC.B	$00,'`',$00,'g',$00,$00,$FF,$FE 
	DC.B	$00,$03,$00,$03,$FE,$00,$FE,$00 
	DC.B	$7F,$80,$00,$00,$00,$00,$01,$F8 
	DC.B	$00,$00,$00,$0F,$00,$00,$FF,$FE 
	DC.B	$00,$03,$00,$03,$FC,$00,$FC,$00 
	DC.B	$7F,$00,$00,$00,$00,$00,'?',$FF 
	DC.B	$00,$00,$C0,$1F,$00,$00,$FD,$FE 
	DC.B	$00,$07,$00,$07,$FC,$00,$FC,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$FF,$FF 
	DC.B	$00,$00,$F0,'?',$00,$00,$F9,$FE 
	DC.B	$00,$07,$00,$07,$F8,$00,$F8,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$03 
	DC.B	$00,$00,$FF,$FF,$00,$00,$FC,$7F 
	DC.B	$00,$00,$E1,$FE,$00,$0F,$00,$0F 
	DC.B	$F8,$00,$F8,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$00,$0F,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,$00,$00,$C1,$FE 
	DC.B	$00,$1F,$00,$1F,$F0,$00,$F0,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$1F 
	DC.B	$00,$00,$FF,$FF,$00,$00,$FF,$FF 
	DC.B	$18,$00,$99,$FE,$00,$1F,$00,$1F 
	DC.B	$E0,$00,$E0,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$00,'?',$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$FF,'8',$00,'9',$FE 
	DC.B	$00,'?',$00,'?',$E0,$00,$E0,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$00,$00,$FF,$1F,$00,$00,$FF,$FE 
	DC.B	'|',$00,'}',$FC,$00,'?',$00,'?' 
	DC.B	$C0,$00,$C0,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$00,$FF,$00,$E0,$F0,$00 
	DC.B	$00,$00,$FF,$FC,$FC,$00,$FC,$00 
	DC.B	$00,$7F,$00,$7F,$C0,$00,$C0,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$01,$FF 
	DC.B	$03,$F8,$C0,$00,$00,$01,'?',$F9 
	DC.B	$FE,$00,$FE,$00,$00,$7F,$00,$7F 
	DC.B	$80,$00,$80,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$01,$FF,$07,$F8,$80,$00 
	DC.B	$00,$01,$1F,$F9,$FE,$00,$FE,$00 
	DC.B	$00,$FF,$00,$FF,$80,$00,$80,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$03,$FF 
	DC.B	$07,$F8,$00,$00,$00,$01,$0F,$FD 
	DC.B	$FF,$00,$FF,$00,$00,$FF,$00,$FF 
	DC.B	$FF,$00,$00,$00,$00,$00,$03,$FE 
	DC.B	$0F,$F8,$00,$00,$00,$00,$07,$FC 
	DC.B	$FF,$00,$FF,$00,$01,$FF,$01,$FF 
	DC.B	$FF,$00,$00,$00,$00,$00,$07,$FC 
	DC.B	$1F,$F0,$00,$00,$00,$00,$03,$FE 
	DC.B	$FF,$80,$FF,$80,$01,$FE,$01,$FE 
	DC.B	$FF,$00,$00,$00,$00,$00,$07,$F8 
	DC.B	$1F,$F0,$00,$00,$00,$00,$01,$FE 
	DC.B	$7F,$80,$7F,$80,$03,$FE,$03,$FE 
	DC.B	$FF,$00,$00,$00,$00,$00,$0F,$F8 
	DC.B	'?',$E0,$00,$00,$00,$00,$01,$FF 
	DC.B	$7F,$C0,$7F,$C0,$03,$FC,$03,$FC 
	DC.B	$FF,$00,$00,$00,$00,$00,$0F,$F0 
	DC.B	$7F,$E0,$00,$00,$00,$00,$00,$FF 
	DC.B	'?',$C0,'?',$C0,$07,$FC,$07,$FC 
	DC.B	$FF,$00,$00,$00,$00,$00,$0F,$F0 
	DC.B	$FF,$C0,$00,$00,$00,$00,$00,$FF 
	DC.B	'?',$E0,'?',$E0,$07,$F8,$07,$F8 
	DC.B	$FF,$03,$00,$00,$00,$03,$0F,$E0 
	DC.B	$FF,$80,$00,$00,$00,$00,$00,$FF 
	DC.B	$1F,$E0,$1F,$E0,$0F,$F8,$0F,$F8 
	DC.B	$FF,$07,$00,$00,$C0,$0F,$00,$00 
	DC.B	$FF,$80,$00,$00,$00,$00,$00,$7F 
	DC.B	$1F,$F0,$9F,$F0,$0F,$F0,$0F,$F0 
	DC.B	$FF,$0F,$00,$00,$FF,$FF,$00,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$0F,$F0,$8F,$F0,$1F,$F0,$1F,$F0 
	DC.B	$FF,$1F,$00,$00,$FF,$FF,$00,$00 
	DC.B	$FE,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$0F,$F8,$8F,$F8,$1F,$E0,$1F,$E0 
	DC.B	$FF,'?',$00,$00,$FF,$FF,$00,$00 
	DC.B	$FC,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$07,$F8,$87,$F8,'?',$E0,'?',$E0 
	DC.B	$FF,$7F,$00,$00,$FF,$FF,$00,$00 
	DC.B	$F0,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$07,$FC,$87,$FC,'?',$C0,'?',$C0 
	DC.B	$FF,$1F,$00,$00,$FF,$FF,$00,$00 
	DC.B	$C0,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$03,$FC,$83,$FC,$7F,$C0,$7F,$C0 
	DC.B	$FF,$07,$00,$00,$FF,$FF,$00,$00 
	DC.B	$00,$00,$00,$7F,$03,$FE,$03,$FE 
	DC.B	$7F,$80,$7F,$80,$FF,$00,$00,$00 
	DC.B	$FF,$F8,$00,$00,$00,$00,$00,$FF 
	DC.B	$01,$FE,$01,$FE,$FF,$80,$FF,$80 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$FF 
	DC.B	$01,$FF,$01,$FF,$FF,$00,$FF,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$0F,$F8 
	DC.B	$00,$00,$00,$FF,$00,$FF,$00,$FF 
	DC.B	$FF,$00,$FF,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$0F,$F8,$00,$00,$01,$FF 
	DC.B	$00,$FF,$00,$FF,$FE,$00,$FE,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$07,$FC 
	DC.B	$00,$00,$03,$FE,$00,$7F,$00,$7F 
	DC.B	$FE,$00,$FE,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$07,$FC,$00,$00,$03,$FE 
	DC.B	$00,$7F,$00,$7F,$FC,$00,$FC,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$03,$FE 
	DC.B	$00,$00,$07,$FC,$00,'?',$00,'?' 
	DC.B	$FC,$00,$FC,$00,$FF,$00,$00,$00 
	DC.B	$00,$00,$03,$FF,$00,$00,$0F,$FC 
	DC.B	$00,'?',$00,'?',$F8,$00,$F8,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$01,$FF 
	DC.B	$00,$00,$80,$00,$00,$00,$1F,$F8 
	DC.B	$00,$1F,$00,$1F,$F8,$00,$F8,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$FF 
	DC.B	$00,$00,$E0,$00,$00,$00,$7F,$F0 
	DC.B	$00,$1F,$00,$1F,$F0,$00,$F0,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$FF 
	DC.B	$00,$00,$F8,$01,$00,$00,$FF,$F0 
	DC.B	$00,$0F,$00,$0F,$F0,$00,$F0,$00 
	DC.B	$FF,$00,$00,$00,$00,$00,$00,$7F 
	DC.B	$00,$00,$FF,$FF,$00,$00,$FF,$E0 
	DC.B	$00,$0F,$00,$0F,$E0,$00,$E0,$00 
	DC.B	$00,$00,$00,'?',$00,$00,$FF,$FF 
	DC.B	$00,$00,$FF,$C0,$00,$07,$00,$07 
	DC.B	$E0,$00,$E0,$00,$00,$00,$00,$1F 
	DC.B	$00,$00,$FF,$FF,$00,$00,$FF,$80 
	DC.B	$00,$03,$00,$03,$C0,$00,$C0,$00 
	DC.B	$00,$00,$00,$07,$00,$00,$FF,$FF 
	DC.B	$00,$00,$FE,$00,$00,$0C,$00,$00 
	DC.B	'??',$00,$00,$00,$00,$00,$03
	DC.B	$00,$00,$FF,$FF,$00,$00,$FC,$00 
	DC.B	$00,$1C,$00,$00,'33',$00,$00
	DC.B	$00,$00,$FF,$FF,$00,$00,$F0,$00 
	DC.B	$00,$0C,$00,$00,'3?',$00,$00
	DC.B	$00,$00,'?',$FF,$00,$00,$C0,$00 
	DC.B	$00,$0C,$00,$00,'33',$00,$00
	DC.B	$00,$00,$01,$F8,$00,'?',$00,$00 
	DC.B	'??',$00,$00

L00A7	MOVE.L	(A0)+,8(A1)
	MOVE.L	(A0)+,$A0(A1)
	MOVE.L	(A0)+,$A8(A1)
	MOVE.L	(A0)+,$140(A1)
	MOVE.L	(A0)+,$148(A1)
	MOVE.L	(A0)+,$150(A1)
	MOVE.L	(A0)+,$1E0(A1)
	MOVE.L	(A0)+,$1E8(A1)
	MOVE.L	(A0)+,$1F0(A1)
	MOVE.L	(A0)+,$280(A1)
	MOVE.L	(A0)+,$288(A1)
	MOVE.L	(A0)+,$290(A1)
	MOVE.L	(A0)+,$298(A1)
	MOVE.L	(A0)+,$2A0(A1)
	MOVE.L	(A0)+,$320(A1)
	MOVE.L	(A0)+,$328(A1)
	MOVE.L	(A0)+,$330(A1)
	MOVE.L	(A0)+,$338(A1)
	MOVE.L	(A0)+,$340(A1)
	MOVE.L	(A0)+,$3C0(A1)
	MOVE.L	(A0)+,$3C8(A1)
	MOVE.L	(A0)+,$3D0(A1)
	MOVE.L	(A0)+,$3D8(A1)
	MOVE.L	(A0)+,$3E0(A1)
	MOVE.L	(A0)+,$460(A1)
	MOVE.L	(A0)+,$468(A1)
	MOVE.L	(A0)+,$470(A1)
	MOVE.L	(A0)+,$478(A1)
	MOVE.L	(A0)+,$480(A1)
	MOVE.L	(A0)+,$500(A1)
	MOVE.L	(A0)+,$508(A1)
	MOVE.L	(A0)+,$510(A1)
	MOVE.L	(A0)+,$518(A1)
	MOVE.L	(A0)+,$520(A1)
	MOVE.L	(A0)+,$5A0(A1)
	MOVE.L	(A0)+,$5A8(A1)
	MOVE.L	(A0)+,$5B0(A1)
	MOVE.L	(A0)+,$5B8(A1)
	MOVE.L	(A0)+,$5C0(A1)
	MOVE.L	(A0)+,$640(A1)
	MOVE.L	(A0)+,$650(A1)
	MOVE.L	(A0)+,$658(A1)
	MOVE.L	(A0)+,$660(A1)
	MOVE.L	(A0)+,$670(A1)
	MOVE.L	(A0)+,$6E0(A1)
	MOVE.L	(A0)+,$6F0(A1)
	MOVE.L	(A0)+,$700(A1)
	MOVE.L	(A0)+,$710(A1)
	MOVE.L	(A0)+,$780(A1)
	MOVE.L	(A0)+,$790(A1)
	MOVE.L	(A0)+,$798(A1)
	MOVE.L	(A0)+,$7A0(A1)
	MOVE.L	(A0)+,$7B0(A1)
	MOVE.L	(A0)+,$820(A1)
	MOVE.L	(A0)+,$830(A1)
	MOVE.L	(A0)+,$838(A1)
	MOVE.L	(A0)+,$840(A1)
	MOVE.L	(A0)+,$850(A1)
	MOVE.L	(A0)+,$8C0(A1)
	MOVE.L	(A0)+,$8D0(A1)
	MOVE.L	(A0)+,$8D8(A1)
	MOVE.L	(A0)+,$8E0(A1)
	MOVE.L	(A0)+,$8E8(A1)
	MOVE.L	(A0)+,$8F0(A1)
	MOVE.L	(A0)+,$960(A1)
	MOVE.L	(A0)+,$970(A1)
	MOVE.L	(A0)+,$978(A1)
	MOVE.L	(A0)+,$980(A1)
	MOVE.L	(A0)+,$988(A1)
	MOVE.L	(A0)+,$990(A1)
	MOVE.L	(A0)+,$A00(A1)
	MOVE.L	(A0)+,$A10(A1)
	MOVE.L	(A0)+,$A18(A1)
	MOVE.L	(A0)+,$A20(A1)
	MOVE.L	(A0)+,$A28(A1)
	MOVE.L	(A0)+,$A30(A1)
	MOVE.L	(A0)+,$AA0(A1)
	MOVE.L	(A0)+,$AB0(A1)
	MOVE.L	(A0)+,$AB8(A1)
	MOVE.L	(A0)+,$AC0(A1)
	MOVE.L	(A0)+,$AC8(A1)
	MOVE.L	(A0)+,$AD0(A1)
	MOVE.L	(A0)+,$B40(A1)
	MOVE.L	(A0)+,$B50(A1)
	MOVE.L	(A0)+,$B58(A1)
	MOVE.L	(A0)+,$B60(A1)
	MOVE.L	(A0)+,$B68(A1)
	MOVE.L	(A0)+,$B70(A1)
	MOVE.L	(A0)+,$BE0(A1)
	MOVE.L	(A0)+,$BF0(A1)
	MOVE.L	(A0)+,$BF8(A1)
	MOVE.L	(A0)+,$C00(A1)
	MOVE.L	(A0)+,$C08(A1)
	MOVE.L	(A0)+,$C10(A1)
	MOVE.L	(A0)+,$C80(A1)
	MOVE.L	(A0)+,$C88(A1)
	MOVE.L	(A0)+,$C90(A1)
	MOVE.L	(A0)+,$C98(A1)
	MOVE.L	(A0)+,$CA0(A1)
	MOVE.L	(A0)+,$CA8(A1)
	MOVE.L	(A0)+,$CB0(A1)
	MOVE.L	(A0)+,$D20(A1)
	MOVE.L	(A0)+,$D28(A1)
	MOVE.L	(A0)+,$D30(A1)
	MOVE.L	(A0)+,$D38(A1)
	MOVE.L	(A0)+,$D40(A1)
	MOVE.L	(A0)+,$D48(A1)
	MOVE.L	(A0)+,$D50(A1)
	MOVE.L	(A0)+,$DC0(A1)
	MOVE.L	(A0)+,$DC8(A1)
	MOVE.L	(A0)+,$DD0(A1)
	MOVE.L	(A0)+,$DD8(A1)
	MOVE.L	(A0)+,$DE0(A1)
	MOVE.L	(A0)+,$DE8(A1)
	MOVE.L	(A0)+,$DF0(A1)
	MOVE.L	(A0)+,$E60(A1)
	MOVE.L	(A0)+,$E68(A1)
	MOVE.L	(A0)+,$E70(A1)
	MOVE.L	(A0)+,$E78(A1)
	MOVE.L	(A0)+,$E80(A1)
	MOVE.L	(A0)+,$E88(A1)
	MOVE.L	(A0)+,$E90(A1)
	MOVE.L	(A0)+,$F00(A1)
	MOVE.L	(A0)+,$F08(A1)
	MOVE.L	(A0)+,$F10(A1)
	MOVE.L	(A0)+,$F18(A1)
	MOVE.L	(A0)+,$F20(A1)
	MOVE.L	(A0)+,$F28(A1)
	MOVE.L	(A0)+,$F30(A1)
	MOVE.L	(A0)+,$FA0(A1)
	MOVE.L	(A0)+,$FA8(A1)
	MOVE.L	(A0)+,$FB0(A1)
	MOVE.L	(A0)+,$FB8(A1)
	MOVE.L	(A0)+,$FC0(A1)
	MOVE.L	(A0)+,$FC8(A1)
	MOVE.L	(A0)+,$FD0(A1)
	MOVE.L	(A0)+,$1040(A1)
	MOVE.L	(A0)+,$1048(A1)
	MOVE.L	(A0)+,$1050(A1)
	MOVE.L	(A0)+,$1058(A1)
	MOVE.L	(A0)+,$1060(A1)
	MOVE.L	(A0)+,$1068(A1)
	MOVE.L	(A0)+,$1070(A1)
	MOVE.L	(A0)+,$10E0(A1)
	MOVE.L	(A0)+,$10E8(A1)
	MOVE.L	(A0)+,$10F0(A1)
	MOVE.L	(A0)+,$10F8(A1)
	MOVE.L	(A0)+,$1100(A1)
	MOVE.L	(A0)+,$1108(A1)
	MOVE.L	(A0)+,$1110(A1)
	MOVE.L	(A0)+,$1180(A1)
	MOVE.L	(A0)+,$1188(A1)
	MOVE.L	(A0)+,$1190(A1)
	MOVE.L	(A0)+,$1198(A1)
	MOVE.L	(A0)+,$11A0(A1)
	MOVE.L	(A0)+,$11A8(A1)
	MOVE.L	(A0)+,$1220(A1)
	MOVE.L	(A0)+,$1228(A1)
	MOVE.L	(A0)+,$1230(A1)
	MOVE.L	(A0)+,$1238(A1)
	MOVE.L	(A0)+,$1240(A1)
	MOVE.L	(A0)+,$1248(A1)
	MOVE.L	(A0)+,$12C0(A1)
	MOVE.L	(A0)+,$12C8(A1)
	MOVE.L	(A0)+,$12D0(A1)
	MOVE.L	(A0)+,$12D8(A1)
	MOVE.L	(A0)+,$12E0(A1)
	MOVE.L	(A0)+,$12E8(A1)
	MOVE.L	(A0)+,$1360(A1)
	MOVE.L	(A0)+,$1368(A1)
	MOVE.L	(A0)+,$1370(A1)
	MOVE.L	(A0)+,$1378(A1)
	MOVE.L	(A0)+,$1380(A1)
	MOVE.L	(A0)+,$1388(A1)
	MOVE.L	(A0)+,$1400(A1)
	MOVE.L	(A0)+,$1408(A1)
	MOVE.L	(A0)+,$1410(A1)
	MOVE.L	(A0)+,$1418(A1)
	MOVE.L	(A0)+,$1420(A1)
	MOVE.L	(A0)+,$1428(A1)
	MOVE.L	(A0)+,$14A0(A1)
	MOVE.L	(A0)+,$14A8(A1)
	MOVE.L	(A0)+,$14B0(A1)
	MOVE.L	(A0)+,$14B8(A1)
	MOVE.L	(A0)+,$14C0(A1)
	MOVE.L	(A0)+,$14C8(A1)
	MOVE.L	(A0)+,$1540(A1)
	MOVE.L	(A0)+,$1548(A1)
	MOVE.L	(A0)+,$1550(A1)
	MOVE.L	(A0)+,$1558(A1)
	MOVE.L	(A0)+,$1560(A1)
	MOVE.L	(A0)+,$1568(A1)
	MOVE.L	(A0)+,$15E0(A1)
	MOVE.L	(A0)+,$15E8(A1)
	MOVE.L	(A0)+,$15F0(A1)
	MOVE.L	(A0)+,$15F8(A1)
	MOVE.L	(A0)+,$1600(A1)
	MOVE.L	(A0)+,$1608(A1)
	MOVE.L	(A0)+,$1680(A1)
	MOVE.L	(A0)+,$1688(A1)
	MOVE.L	(A0)+,$1690(A1)
	MOVE.L	(A0)+,$1698(A1)
	MOVE.L	(A0)+,$16A0(A1)
	MOVE.L	(A0)+,$16A8(A1)
	MOVE.L	(A0)+,$1720(A1)
	MOVE.L	(A0)+,$1728(A1)
	MOVE.L	(A0)+,$1730(A1)
	MOVE.L	(A0)+,$1738(A1)
	MOVE.L	(A0)+,$1740(A1)
	MOVE.L	(A0)+,$1748(A1)
	MOVE.L	(A0)+,$17C0(A1)
	MOVE.L	(A0)+,$17C8(A1)
	MOVE.L	(A0)+,$17D0(A1)
	MOVE.L	(A0)+,$17D8(A1)
	MOVE.L	(A0)+,$17E0(A1)
	MOVE.L	(A0)+,$17E8(A1)
	MOVE.L	(A0)+,$1860(A1)
	MOVE.L	(A0)+,$1868(A1)
	MOVE.L	(A0)+,$1870(A1)
	MOVE.L	(A0)+,$1878(A1)
	MOVE.L	(A0)+,$1880(A1)
	MOVE.L	(A0)+,$1888(A1)
	MOVE.L	(A0)+,$1900(A1)
	MOVE.L	(A0)+,$1908(A1)
	MOVE.L	(A0)+,$1910(A1)
	MOVE.L	(A0)+,$1918(A1)
	MOVE.L	(A0)+,$1920(A1)
	MOVE.L	(A0)+,$1928(A1)
	MOVE.L	(A0)+,$19A0(A1)
	MOVE.L	(A0)+,$19A8(A1)
	MOVE.L	(A0)+,$19B0(A1)
	MOVE.L	(A0)+,$19B8(A1)
	MOVE.L	(A0)+,$19C0(A1)
	MOVE.L	(A0)+,$19C8(A1)
	MOVE.L	(A0)+,$1A40(A1)
	MOVE.L	(A0)+,$1A48(A1)
	MOVE.L	(A0)+,$1A58(A1)
	MOVE.L	(A0)+,$1A60(A1)
	MOVE.L	(A0)+,$1A68(A1)
	MOVE.L	(A0)+,$1AE0(A1)
	MOVE.L	(A0)+,$1AE8(A1)
	MOVE.L	(A0)+,$1AF8(A1)
	MOVE.L	(A0)+,$1B00(A1)
	MOVE.L	(A0)+,$1B08(A1)
	MOVE.L	(A0)+,$1B80(A1)
	MOVE.L	(A0)+,$1B98(A1)
	MOVE.L	(A0)+,$1BA0(A1)
	MOVE.L	(A0)+,$1BA8(A1)
	MOVE.L	(A0)+,$1C20(A1)
	MOVE.L	(A0)+,$1C28(A1)
	MOVE.L	(A0)+,$1C38(A1)
	MOVE.L	(A0)+,$1C40(A1)
	MOVE.L	(A0)+,$1C48(A1)
	MOVE.L	(A0)+,$1CC0(A1)
	MOVE.L	(A0)+,$1CC8(A1)
	MOVE.L	(A0)+,$1CD8(A1)
	MOVE.L	(A0)+,$1CE0(A1)
	MOVE.L	(A0)+,$1CE8(A1)
	MOVE.L	(A0)+,$1D60(A1)
	MOVE.L	(A0)+,$1D68(A1)
	MOVE.L	(A0)+,$1D78(A1)
	MOVE.L	(A0)+,$1D80(A1)
	MOVE.L	(A0)+,$1D88(A1)
	MOVE.L	(A0)+,$1E00(A1)
	MOVE.L	(A0)+,$1E08(A1)
	MOVE.L	(A0)+,$1E18(A1)
	MOVE.L	(A0)+,$1E20(A1)
	MOVE.L	(A0)+,$1E28(A1)
	MOVE.L	(A0)+,$1EA0(A1)
	MOVE.L	(A0)+,$1EA8(A1)
	MOVE.L	(A0)+,$1EB8(A1)
	MOVE.L	(A0)+,$1EC0(A1)
	MOVE.L	(A0)+,$1EC8(A1)
	MOVE.L	(A0)+,$1F40(A1)
	MOVE.L	(A0)+,$1F48(A1)
	MOVE.L	(A0)+,$1F58(A1)
	MOVE.L	(A0)+,$1F60(A1)
	MOVE.L	(A0)+,$1F68(A1)
	MOVE.L	(A0)+,$1FE0(A1)
	MOVE.L	(A0)+,$1FE8(A1)
	MOVE.L	(A0)+,$1FF0(A1)
	MOVE.L	(A0)+,$1FF8(A1)
	MOVE.L	(A0)+,$2000(A1)
	MOVE.L	(A0)+,$2008(A1)
	MOVE.L	(A0)+,$2080(A1)
	MOVE.L	(A0)+,$2088(A1)
	MOVE.L	(A0)+,$2090(A1)
	MOVE.L	(A0)+,$2098(A1)
	MOVE.L	(A0)+,$20A0(A1)
	MOVE.L	(A0)+,$20A8(A1)
	MOVE.L	(A0)+,$2120(A1)
	MOVE.L	(A0)+,$2128(A1)
	MOVE.L	(A0)+,$2130(A1)
	MOVE.L	(A0)+,$2138(A1)
	MOVE.L	(A0)+,$2140(A1)
	MOVE.L	(A0)+,$2148(A1)
	MOVE.L	(A0)+,$21C0(A1)
	MOVE.L	(A0)+,$21C8(A1)
	MOVE.L	(A0)+,$21D0(A1)
	MOVE.L	(A0)+,$21D8(A1)
	MOVE.L	(A0)+,$21E0(A1)
	MOVE.L	(A0)+,$21E8(A1)
	MOVE.L	(A0)+,$2268(A1)
	MOVE.L	(A0)+,$2270(A1)
	MOVE.L	(A0)+,$2278(A1)
	MOVE.L	(A0)+,$2280(A1)
	MOVE.L	(A0)+,$2288(A1)
	MOVE.L	(A0)+,$2308(A1)
	MOVE.L	(A0)+,$2310(A1)
	MOVE.L	(A0)+,$2318(A1)
	MOVE.L	(A0)+,$2320(A1)
	MOVE.L	(A0)+,$2328(A1)
	MOVE.L	(A0)+,$23A8(A1)
	MOVE.L	(A0)+,$23B0(A1)
	MOVE.L	(A0)+,$23B8(A1)
	MOVE.L	(A0)+,$23C8(A1)
	MOVE.L	(A0)+,$23D0(A1)
	MOVE.L	(A0)+,$2448(A1)
	MOVE.L	(A0)+,$2450(A1)
	MOVE.L	(A0)+,$2458(A1)
	MOVE.L	(A0)+,$2468(A1)
	MOVE.L	(A0)+,$2470(A1)
	MOVE.L	(A0)+,$24F0(A1)
	MOVE.L	(A0)+,$24F8(A1)
	MOVE.L	(A0)+,$2508(A1)
	MOVE.L	(A0)+,$2510(A1)
	MOVE.L	(A0)+,$2590(A1)
	MOVE.L	(A0)+,$2598(A1)
	MOVE.L	(A0)+,$25A8(A1)
	MOVE.L	(A0)+,$25B0(A1)
	MOVE.L	(A0)+,$2630(A1)
	MOVE.L	(A0)+,$2648(A1)
	MOVE.L	(A0)+,$2650(A1)
	RTS

L00A8	DC.B	'`x',$81,$80,$00,$00,$00,$10
	DC.B	'<',$10,$C0,'a|',$00,$80,$CC
	DC.B	'<<',$C0,$C0,$00,$00,$00,$01
	DC.B	'pp',$80,$00,$00,$00,$00,$03
	DC.B	$F0,$0F,$03,'0',$00,$18,$00,' ' 
	DC.B	'L',$B8,$80,'@pt',$00,$88 
	DC.B	'pL',$80,$80,$00,$01,$00,$00
	DC.B	$F0,$E0,$00,$00,$00,$01,$00,$02 
	DC.B	$F1,$10,$02,' ',$00,'|',$00,$00 
	DC.B	$CC,'p',$00,$00,'p',$CC,$00,$00 
	DC.B	$FC,$C0,$00,$00,$E0,$F8,$01,$00 
	DC.B	$00,$03,$00,$00,$03,'?',$00,$00 

L00A9	MOVE.L	(A0)+,$28(A1)
	MOVE.L	(A0)+,$A0(A1)
	MOVE.L	(A0)+,$A8(A1)
	MOVE.L	(A0)+,$B0(A1)
	MOVE.L	(A0)+,$B8(A1)
	MOVE.L	(A0)+,$C0(A1)
	MOVE.L	(A0)+,$C8(A1)
	MOVE.L	(A0)+,$D0(A1)
	MOVE.L	(A0)+,$D8(A1)
	MOVE.L	(A0)+,$140(A1)
	MOVE.L	(A0)+,$148(A1)
	MOVE.L	(A0)+,$150(A1)
	MOVE.L	(A0)+,$158(A1)
	MOVE.L	(A0)+,$160(A1)
	MOVE.L	(A0)+,$168(A1)
	MOVE.L	(A0)+,$170(A1)
	MOVE.L	(A0)+,$178(A1)
	MOVE.L	(A0)+,$1E0(A1)
	MOVE.L	(A0)+,$1E8(A1)
	MOVE.L	(A0)+,$1F0(A1)
	MOVE.L	(A0)+,$1F8(A1)
	MOVE.L	(A0)+,$208(A1)
	MOVE.L	(A0)+,$210(A1)
	MOVE.L	(A0)+,$218(A1)
	RTS

titles	incbin	titles.dat

blast_on_titles
OFF	set	0
	REPT	14
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	ENDR
OFF	set	OFF+32
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8

	REPT	14
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	ENDR
OFF	set	OFF+32
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8

	REPT	14
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	ENDR
OFF	set	OFF+32
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8

	REPT	14
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	ENDR
OFF	set	OFF+32
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8

	REPT	14
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	ENDR
OFF	set	OFF+32
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8
	move.w	(a0)+,OFF(a1)
OFF	set	OFF+8


	REPT	25
	move.w	(a0)+,OFF(a1)
	move.w	(a0)+,OFF+8(a1)
	move.w	(a0)+,OFF+16(a1)
	move.w	(a0)+,OFF+24(a1)
	move.w	(a0)+,OFF+32(a1)
	move.w	(a0)+,OFF+40(a1)
	move.w	(a0)+,OFF+48(a1)
	move.w	(a0)+,OFF+56(a1)
	move.w	(a0)+,OFF+64(a1)
	move.w	(a0)+,OFF+72(a1)
	move.w	(a0)+,OFF+80(a1)
	move.w	(a0)+,OFF+88(a1)
	move.w	(a0)+,OFF+96(a1)
	move.w	(a0)+,OFF+104(a1)
OFF	set	OFF+160
	ENDR
	rts

intro_pic	incbin	intro.pi1

tune		incbin	lap33.mus

L00B0	DC.B	$FC,$E0 
L00B1	DC.B	$03,$C0 
L00B2	DC.B	$00,'P' 
L00B3	DC.B	$FC,$E0 
L00B4	DC.B	$00,$00 
L00B5	DC.B	$00,$00 
L00B6	DC.B	$00,$00 
L00B7	DCB.W	2,0 

demo_keys	dc.b	0, $02		;key 1
		dc.b	1, $03		;key 2
		dc.b	2, $04		;key 3
		dc.b	3, $05		;key 4
		dc.b	4, $06		;key 5
		dc.b	5, $07		;key 6
		dc.b	6, $08		;key 7
		dc.b	7, $09		;key 8
		dc.b	8, $0a		;key 9

		dc.b	0, $6d		;keypad 1
		dc.b	1, $6e		;keypad 2
		dc.b	2, $6f		;keypad 3
		dc.b	3, $6a		;keypad 4
		dc.b	4, $6b		;keypad 5
		dc.b	5, $6c		;keypad 6
		dc.b	6, $67		;keypad 7
		dc.b	7, $68		;keypad 8
		dc.b	8, $69		;keypad 9
	dc.b	-1,-1

L00B9	dc.w	f1-L00B9
	dc.w	f2-L00B9
	dc.w	f3-L00B9
	dc.w	f4-L00B9
	dc.w	f5-L00B9
	dc.w	f6-L00B9
	dc.w	f7-L00B9
	dc.w	f8-L00B9
	dc.w	f9-L00B9

f1	dc.b	'$$DF.PRG',0
	even
f2	dc.b	'FOLLOWME.PRG',$00
	even
f3	dc.b	'ALK.PRG',$00
	even
f4	DC.B	'KGB.PRG',$00
	even
f5	dc.b	'ADRENALI.PRG',$00
	even
f6	dc.b	'PUL_155.PRG',$00
	even
f7	dc.b	'WOLV_IKI.PRG',$00
	even
f8	dc.b	'JMP.PRG',$00 
	even
f9	DC.B	'COPIER.POV',$00
	even
 BSS
bssstart	ds.b	34

key		ds.w	1 

vsync_flag	ds.w	1 

delay_key	ds.w	1 
hertz_byte	ds.b	1 

hertz_sw	ds.b	1 

vect_save	ds.l	3

store_system	ds.b	8 

save_stk	ds.l	1 
screen_base	ds.l	1 

scr_eor	ds.l	1

	ds.b	25856
screens	ds.b	57600
	ds.b	57600
bssend
